/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.ux.bootstarter.configer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoClientPageVariableProvider;
import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.ConfigerContext;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoPagesConfig;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.yigo.ux.bootstarter.data.SpringUxConfigData;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringUxEventListenerProvider;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringUxPackageProvider;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringWebUxSettingProvider;
import com.bokesoft.yigo.ux.bootstarter.yigoext.mid.UxSettingService;
import com.bokesoft.yigo.ux.defination.classic.YigoClassicUxSetting;
import com.bokesoft.yigo.ux.defination.classic.config.UxSystemParameters;
import com.bokesoft.yigo.ux.defination.mobile.YigoMobileUxSetting;
import com.bokesoft.yigo.ux.impl.DefaultUxFactory;
import com.bokesoft.yigo.ux.intf.ext.IClassicDecorationProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxEventListenerProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxPackageProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxSettingProvider;
import com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.model.StaticReferenceIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ResourceLoader;

@Configuration
public class UxConfiger {
    private static String[] DEFAULT_IGNORE_RESOURCES = new String[]{"/yigo-ux-default-project/Entry.xml"};
    private static final Logger log = LoggerFactory.getLogger(UxConfiger.class);
    @Autowired
    private ApplicationContext appCtx;
    @Autowired
    private SpringUxConfigData configData;
    @Autowired
    private YigoPagesConfig pagesConfig;
    @Autowired
    private YigoInstanceManager yigoInstanceManager;
    @Autowired
    private List<IClassicDecorationProvider> additionalDecorationProviders;

    @Autowired
    public void setSpringUxCofnigData2Service(SpringUxConfigData configData) {
        UxSettingService.setSpringCfgUxConfigData(configData);
    }

    @Bean(value={"yigoUX_initDefaultUxFactory"})
    public DefaultUxFactory yigoUX_initDefaultUxFactory() throws IOException {
        DefaultUxFactory.setup((IUxEventListenerProvider)new SpringUxEventListenerProvider(this.appCtx), (UxSystemParameters)this.configData.getSystemParameters());
        SpringUxPackageProvider pp = new SpringUxPackageProvider(this.appCtx);
        DefaultUxFactory.setUxPackageProvider((IUxPackageProvider)pp);
        SpringWebUxSettingProvider sp = new SpringWebUxSettingProvider(this.configData, (ResourceLoader)this.appCtx, this.additionalDecorationProviders);
        DefaultUxFactory.setUxSettingProvider((IUxSettingProvider)sp);
        return new DefaultUxFactory();
    }

    @Bean
    @DependsOn(value={"yigoUX_initDefaultUxFactory"})
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_ClassicUxSetting() {
        return new YigoClientPageVariableProvider(){

            public boolean support(PageBuildContext ctx) {
                return PageBuildContext.PageClass.LOGIN == ctx.getPageClass() || PageBuildContext.PageClass.MAINFRAME == ctx.getPageClass() || PageBuildContext.PageClass.WAITING == ctx.getPageClass();
            }

            public Map<String, Object> getVariables(PageBuildContext ctx) {
                IUxSettingProvider uxSettingProvider = DefaultUxFactory.getUxSettingProvider();
                HashMap<String, Object> result = new HashMap<String, Object>();
                YigoClassicUxSetting uxSetting = uxSettingProvider.getClassicUxSetting(ctx.getDefaultContext());
                result.put(YigoClassicUxSetting.class.getSimpleName(), uxSetting);
                return result;
            }
        };
    }

    @Bean
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_MobileUxSetting() {
        return new YigoClientPageVariableProvider(){

            public boolean support(PageBuildContext ctx) {
                return PageBuildContext.PageClass.APPHOME == ctx.getPageClass();
            }

            public Map<String, Object> getVariables(PageBuildContext ctx) {
                IUxSettingProvider uxSettingProvider = DefaultUxFactory.getUxSettingProvider();
                HashMap<String, Object> result = new HashMap<String, Object>();
                YigoMobileUxSetting uxMobileSetting = uxSettingProvider.getMobileUxSetting(ctx.getDefaultContext());
                result.put(YigoMobileUxSetting.class.getSimpleName(), uxMobileSetting);
                return result;
            }
        };
    }

    @Bean
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_InstanceStatue() {
        return new YigoClientPageVariableProvider(){

            public boolean support(PageBuildContext ctx) {
                return PageBuildContext.PageClass.LOGIN == ctx.getPageClass() || PageBuildContext.PageClass.WAITING == ctx.getPageClass();
            }

            public Map<String, Object> getVariables(PageBuildContext pageBuildContext) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(InstanceStatus.class.getSimpleName(), UxConfiger.this.yigoInstanceManager.getInstanceStatus());
                return result;
            }
        };
    }

    @Bean
    public YigoRawConfiger yigoUX_addYigoUxDefaultSolution() {
        final ArrayList<String> ignoreSources = new ArrayList<String>();
        if (!this.configData.getFullMode()) {
            ignoreSources.addAll(Arrays.asList(DEFAULT_IGNORE_RESOURCES));
        }
        return new YigoRawConfiger(){

            public void prepare(ConfigerContext context) {
                context.addSolution("yigo-ux-default-solution", SpringResourceMultiSolutionMetaResolverFactory.class, SpringResourceMultiSolutionMetaResolverFactory.buildParas((String)"classpath:/yigo-ux-default-solution", (List)ignoreSources));
            }
        };
    }

    @Bean
    public StaticReferenceIndicator yigoUX_buildDefaultStaticReferenceIndicator() {
        return new StaticReferenceIndicator(new String[]{"/yesui/ux/**"}, new String[]{"classpath*:/webapps/yigo/yesui/ux/**"}, new String[]{"**/lib/less.js/**"});
    }

    @Bean
    public StaticReferenceIndicator yigoUX_buildOverrideStaticReferenceIndicators() {
        return new StaticReferenceIndicator(new String[]{"/yesui/ux/**", "/yesui/home/**"}, new String[]{"classpath*:/override-yigo-webapps/yigo/yesui/ux/**", "classpath*:/override-yigo-webapps/yigo/yesui/home/**"}, new String[]{"**/lib/less.js/**"});
    }

    @PostConstruct
    public void initVariableProviderSettings() {
        String waitingLoc;
        String mainframeLoc;
        boolean overrideEnabled = this.configData.getOverrideYigo().isEnabled();
        if (!overrideEnabled) {
            return;
        }
        YigoPagesConfig.DefaultPageResourceLocations sysDefaultLocs = YigoPagesConfig.DefaultPageResourceLocations.buildDefault();
        String sysLoginLoc = sysDefaultLocs.getLogin();
        String sysMainframeLoc = sysDefaultLocs.getMainframe();
        String sysWaitingLoc = sysDefaultLocs.getWaiting();
        YigoPagesConfig.DefaultPageResourceLocations prLocs = this.pagesConfig.getDefaultPageResourceLocations();
        String loginLoc = prLocs.getLogin();
        if (StringUtils.equals((CharSequence)loginLoc, (CharSequence)sysLoginLoc)) {
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/login.html";
            prLocs.setLogin(overrideVal);
            log.info("\u542f\u7528 ux.override.enabled, Login \u9875\u9762\u8d44\u6e90\u8bbe\u7f6e\u53d8\u5316 {} -> {} .", (Object)sysLoginLoc, (Object)overrideVal);
        }
        if (StringUtils.equals((CharSequence)(mainframeLoc = this.pagesConfig.getDefaultPageResourceLocations().getMainframe()), (CharSequence)sysMainframeLoc)) {
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/mainframe.html";
            prLocs.setMainframe(overrideVal);
            log.info("\u542f\u7528 ux.override.enabled, Mainframe \u9875\u9762\u8d44\u6e90\u53d8\u5316 {} -> {} .", (Object)sysMainframeLoc, (Object)overrideVal);
        }
        if (StringUtils.equals((CharSequence)(waitingLoc = this.pagesConfig.getDefaultPageResourceLocations().getWaiting()), (CharSequence)sysWaitingLoc)) {
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/login.html";
            prLocs.setWaiting(overrideVal);
            log.info("\u542f\u7528 ux.override.enabled, Waiting \u9875\u9762\u8d44\u6e90\u53d8\u5316 {} -> {} .", (Object)sysWaitingLoc, (Object)overrideVal);
        }
    }
}

