import { formRender } from "../util/formRender.js";
(function () {
    var instance;

    YIUI.rightSlideDrawer = {
        hide: function () {
            instance.hide();
        },
        getInstance: function () {
            if (!instance) {
                instance = new RightSlideDrawer();
            }
            return instance;
        },
        show: function (formKey, params) {
            if (!instance) {
                var options = {
                    formKey,
                    transmitParas: params,
                };
                this.getInstance().formRender(options);
            }
            instance.show();
        },
    };
    function RightSlideDrawer() {
        this.init();
    }

    RightSlideDrawer.prototype = {
        constructor: RightSlideDrawer,

        init: function () {
            this.createHTML();
            this.install();
        },

        createHTML: function () {
            this.$container = $('<div class="drawer-container"></div>');
            this.$drawer = $("<div class='drawer'></div");
            this.$drawerInner = $("<div class='drawer-inner'></div");
            this.$drawerInner.appendTo(this.$drawer);
            this.$drawer.appendTo(this.$container);
            this.$container.appendTo($("body"));
        },

        getContainer: function () {
            return this.$drawerInner;
        },

        show() {
            this.$container.addClass("show");
        },

        formRender: function (options) {
            var render = formRender(options);
            render.render(this.$drawerInner);
        },

        hide : function(){
            this.$container.removeClass("show");
        },

        close : function(){
            this.$container.remove();
            instance = null;
        },

        install: function () {
            this.$container.on("click", () => {
                this.hide();
                return false;
            });

            this.$drawer.on("click", () => false);

            this.$drawerInner.close = this.close.bind(this);
        }
    };
})();
