$(function () {
    YIUI.MainTree.addFavorite = function () {
        var $favoriteList,
            $favorite,
            $favoriteAnchor,
            service = new YIUI.RemoteService(),
            formkey = getFormkey(),
            preferData,
            favoriteData = [];
        init();

        function init() {
            createFavorites();
            addFavoriteBtnToTmNode();
            getPreferData().then(function (res) {
                preferData = res;
                favoriteData = formatFavoriteData(res.favorites);
                if (favoriteData || favoriteData.length) {
                    setHasFavoriteMenu();
                    createFavoriteList();
                }
                //treeAnchorClickHandle();
            });
            install();
        }

        function createFavorites() {
            var html =
                '<div class="favorite custom-menu">' +
                "<a class='favorite-anchor'></a>" +
                "<ul class='favorite-list'></ul>" +
                "</div>";
            $favorite = $(html);
            $favoriteList = $favorite.find(".favorite-list");
            $favoriteAnchor = $favorite.find(".favorite-anchor");
            $favorite.prependTo($(".navRight"));
        }

        function addFavoriteBtnToTmNode() {
            var $btn = $("<i class='favorite-btn'></i>");
            $("a.noExpand").prepend($btn);
        }

        function createFavoriteList() {
            favoriteData.forEach(function (path) {
                addFavoriteItem(path);
            });
        }

        function addFavoriteItem(path) {
            var $node = getNodeFromPath(path),
                $a = $node.children("a.tm-anchor.noExpand"),
                text = $a.attr("title");

            var $li = $(
                "<li class='favorite-item hasFavorite'>" + text + "</li>"
            )
                .attr("from", path)
                .on("click", function () {
                    $a.trigger("click");
                })
                .appendTo($(".favorite-list"));
            createFavoriteItemBtn($li, path);
        }

        function createFavoriteItemBtn($parent, path) {
            var $btn = $('<span class="favorite-button">').appendTo($parent);
            $btn.on("click", function () {
                var res = updatePreference("remove", path);
                if (res) {
                    res.done(function () {
                        $parent.remove();
                        $(
                            'li.tm-node.hasFavorite[path="' + path + '"]'
                        ).removeClass("hasFavorite");
                    });
                }
                return false;
            }).on("mouseleave", function () {
                return false;
            });
        }

        function removeFavoriteItem(path) {
            $('.favorite-item[from="' + path + '"]').remove();
        }

        function install() {
            $(".favorite-btn").on("click", function (e) {
                var $node = $(this).closest(".tm-node"),
                    path = $node.attr("path"),
                    handleName = "add";

                if ($node.hasClass("hasFavorite")) handleName = "remove";

                var res = updatePreference(handleName, path);
                if (res) {
                    res.done(function () {
                        $node.toggleClass("hasFavorite");
                        if (handleName == "add") addFavoriteItem(path);
                        if (handleName == "remove") removeFavoriteItem(path);
                    });
                }
                return false;
            }).on("mouseleave", function () {
                return false;
            });

            $favoriteAnchor.on("click", function () {
                var isShow = $favoriteList.css("display") !== "none";
                if (isShow) {
                    $favoriteList.slideUp();
                } else {
                    $favoriteList.empty();
                    createFavoriteList();
                    $favoriteList.slideDown("fast");
                }
            });

            $favorite.on("mouseleave", function () {
                $favoriteList.slideUp();
            });

            $(".favorite-item").on("click", function () {
                $favoriteList.slideUp();
            });
        }

        function getPreferData() {
            return service.loadPreference(formkey);
        }

        //获取第一个formkey作为savePreference的key，
        function getFormkey() {
            return $(".tm-node[formkey]").attr("formkey");
        }

        function formatFavoriteData(favoritesStr) {
            favoritesStr = favoritesStr || "[]"; 
            var favorites = JSON.parse(favoritesStr);
            if (!favorites || !favorites.length) return [];

            return favorites.filter(function (path) {
                return getNodeFromPath(path).length > 0;
            });
        }

        function setHasFavoriteMenu() {
            favoriteData.forEach(function (path) {
                getNodeFromPath(path).addClass("hasFavorite");
            });
        }

        function getNodeFromPath(path) {
            return $(".tm-node[path='" + path + "']");
        }

        function updatePreference(handleName, favoritePath) {
            var i = $.inArray(favoritePath, favoriteData);

            if (handleName == "add" && i === -1) {
                favoriteData.push(favoritePath);
            } else if (handleName == "remove" && i > -1) {
                favoriteData.splice(i, 1);
            } else {
                return null;
            }

            preferData.favorites = JSON.stringify(favoriteData);
            return service.savePreference(formkey, preferData);
        }
    };
});
