package com.bokesoft.yigo.ux.bootstarter.yigoext.service;

import java.util.HashMap;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class YigoUxService extends GeneralService<DefaultContext> {
    public static final String YIGO_UX_SERVICE = "YigoUxService";

    private static HashMap<String, IServiceCmd<?>> prototype = null;
    static {
        prototype = new HashMap<>();
        GeneralService.initPrototype(prototype, new YigoUxService());
    }

    @Override
    public String getServiceName() {
        return YIGO_UX_SERVICE;
    }

    @Override
    public void checkSecurity(DefaultContext var1, String var2, StringHashMap<Object> var3) throws Throwable {
        //不需要登录即可访问
    }

    @Override
    public IServiceProvider<DefaultContext> newInstance() {
        return new YigoUxService();
    }

    @Override
    protected Object[][] getCmdImplTable() {
        return new Object[][]{
            {"GetSetting", new GetSettingCmd()}
        };
    }

    @Override
    protected IServiceCmd<DefaultContext> getDefaultImpl() {
        return null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public IServiceCmd<DefaultContext> getPrototype(DefaultContext context, String cmd) {
        return (IServiceCmd<DefaultContext>) YigoUxService.prototype.get(cmd);
    }
    
}
