package com.bokesoft.yigo.ux.bootstarter.yigoext.service;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.ux.defination.classic.YigoClassicUxSetting;
import com.bokesoft.yigo.ux.impl.DefaultUxFactory;
import com.fasterxml.jackson.databind.ObjectMapper;

public class GetSettingCmd extends DefaultServiceCmd{
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        //没有参数, 无需处理
    }

    @Override
    public Object doCmd(DefaultContext context) throws Throwable {
        YigoClassicUxSetting setting = DefaultUxFactory.getUxSettingProvider().getClassicUxSetting(context);
        String json = objectMapper.writeValueAsString(setting);
        return new JSONObject(json);
    }

    @Override
    public String getCmd() {
        return "GetSetting";
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new GetSettingCmd();
    }
    
}
