package com.bokesoft.yigo.ux.bootstarter.yigoext.mid;

import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCacheManager;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class UxSettingFormula {

    public static void CheckCanEnable(DefaultContext context) throws Throwable {
        Document doc = context.getDocument();
        DataTable headDt = doc.get(0);
        headDt.first();
        if(headDt.getLong("enable") == 1){
            String checkSql = "SELECT CODE FROM UX_AdminConfig WHERE enable=? and OID !=?";
            DataTable dt = context.getDBManager().execPrepareQuery(checkSql, 1, doc.getOID());

            List<String> enabledCodes = new ArrayList<>(dt.size());
            dt.beforeFirst();
            while(dt.next()){
                enabledCodes.add(dt.getString("CODE"));
            }
            if( dt.size() >0 ){
                throw new RuntimeException("存在已启用的配置: "+ StringUtils.join(enabledCodes,", "));
            }
        }
    }

    public static void ClearUxConfigCache() {
        SqlQueryCacheManager.getCache(UxSettingCache.class).clear();
    }
}
