package com.bokesoft.yigo.ux.bootstarter.override;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * FIXME 暂时采用覆盖的方式替换原 yigo webapps 中的部分资源
 */
@Configuration
@ConditionalOnProperty(name="yigoee.tech.bootsupport.ux.override-yigo.enabled", havingValue="true", matchIfMissing=false)
public class OverrideYigoResourceWebMvcConfigurer implements WebMvcConfigurer {

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/yesui/ux/**")
                .addResourceLocations("classpath:/override-yigo-webapps/yigo/yesui/ux/");
    }
}
