package com.bokesoft.yigo.ux.bootstarter.override;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * FIXME 暂时采用覆盖的方式替换原 yigo webapps 中的部分资源
 */
@Controller
@ConditionalOnProperty(name="yigoee.tech.bootsupport.ux.override-yigo.enabled", havingValue="true", matchIfMissing=false)
public class OverrideYigoResourceJsController {
    @Autowired
    private ResourceLoader resourceLoader;

    @GetMapping("/yesui/home/navigation.js")
	public ResponseEntity<String> navigationJs() throws IOException {
		return buildJs("classpath:/override-yigo-webapps/yigo/yesui/home/navigation.js");
	}
  
    private ResponseEntity<String> buildJs(String loc) throws IOException{
        Resource resource = resourceLoader.getResource(loc);
		Assert.notNull(resource, "无法找到资源 - '"+loc+"'");
		
		try(InputStream is = resource.getInputStream()){
            String js = IOUtils.toString(is, "UTF-8");

            MultiValueMap<String, String> headers = new HttpHeaders();
			headers.set(HttpHeaders.CACHE_CONTROL, CacheControl.noCache().cachePrivate().mustRevalidate().getHeaderValue());
            headers.add(HttpHeaders.CONTENT_TYPE, "application/javascript");

			ResponseEntity<String> re = new ResponseEntity<>(js, headers, HttpStatus.OK);
			return re;
        }
    }
}
