package com.bokesoft.yigo.ux.bootstarter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.ApplicationContext;

import com.bokesoft.yigo.ux.defination.classic.navbar.NavbarPackage;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionPackage;
import com.bokesoft.yigo.ux.defination.common.themes.ThemePackage;
import com.bokesoft.yigo.ux.intf.providers.IUxPackageProvider;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Spring 环境下的 {@link IUxPackageProvider} 实现, 以 Bean 的方式获取所有可用的 Ux Package
 */
public class SpringUxPackageProvider implements IUxPackageProvider {
    private ApplicationContext ctx;

    public SpringUxPackageProvider(ApplicationContext ctx){
        this.ctx = ctx;
    }

    @Override
    public List<NavbarPackage> getNavbars() {
        Map<String, NavbarPackage> beans = ctx.getBeansOfType(NavbarPackage.class);
        return new ArrayList<>(beans.values());
    }

    @Override
    public List<ThemePackage> getThemes() {
        Map<String, ThemePackage> beans = ctx.getBeansOfType(ThemePackage.class);

        Collection<ThemePackage> origThemePackages = beans.values();

        ArrayList<ThemePackage> result = new ArrayList<ThemePackage>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (ThemePackage item : origThemePackages) {
            // 为了避免原始 Themes 数据丢失(被更改), 此处需要 clone
            // FIXME 使用 ObjectMapper 实现 clone, 可能存在一定的性能影响
            ThemePackage clonedThemePackage = objectMapper.convertValue(item, ThemePackage.class);

            result.add(clonedThemePackage);
        }

        return result;
    }

    @Override
    public List<NavActionPackage> getNavActions() {
        Map<String, NavActionPackage> beans = ctx.getBeansOfType(NavActionPackage.class);
        return new ArrayList<>(beans.values());
    }

}
