package com.bokesoft.yigo.ux.bootstarter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.context.ApplicationContext;

import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.yigo.ux.intf.events.IClassicUxSettingEventListener;
import com.bokesoft.yigo.ux.intf.events.IMobileUxSettingEventListener;
import com.bokesoft.yigo.ux.intf.providers.IUxEventListenerProvider;

public class SpringUxEventListenerProvider implements IUxEventListenerProvider{
    private ApplicationContext ctx;

    public SpringUxEventListenerProvider(ApplicationContext ctx){
        this.ctx = ctx;
    }

    @Override
    public List<IClassicUxSettingEventListener> getYigoClassicUxSettingEventListeners() {
        Map<String, IClassicUxSettingEventListener> beans = ctx.getBeansOfType(IClassicUxSettingEventListener.class);
        ArrayList<IClassicUxSettingEventListener> listeners = new ArrayList<>(beans.values());

        //依赖排序
        List<IClassicUxSettingEventListener> sorted = DependencySortCore.sort(listeners);

        return sorted;
    }

    @Override
    public List<IMobileUxSettingEventListener> getYigoMobileUxSettingEventListeners() {
        Map<String, IMobileUxSettingEventListener> beans = ctx.getBeansOfType(IMobileUxSettingEventListener.class);
        ArrayList<IMobileUxSettingEventListener> listeners = new ArrayList<>(beans.values());

        // 依赖排序
        List<IMobileUxSettingEventListener> sorted = DependencySortCore.sort(listeners);

        return sorted;
    }

}
