package com.bokesoft.yigo.ux.bootstarter.data.additional;

import java.util.List;
import java.util.Map;

import com.bokesoft.yigo.ux.defination.common.themes.ThemeOption;
import com.bokesoft.yigo.ux.utils.PackagePathUtils;

/**
 * 主题的额外设置
 */
public class AdditionalThemeSetting {
    /** 主题, 支持通配符, 具体格式参考 {@link PackagePathUtils#buildThemePackagePath(ThemeOption, boolean)}(不包含前缀) */
    private String theme;

    /** 额外 less 变量, Key 为 变量名(不需要开头的 "@"), Value 为 变量值 */
    private Map<String, String> lessVariables;
    /** 额外 css 变量, Key 为 变量名(不需要开头的 "--"), Value 为 变量值 */
    private Map<String, String> cssVariables;

    /** 扩展 CSS/LESS 文件的 URL 地址 */
    private List<String> extendCssUrls;

    public String getTheme() {
        return theme;
    }
    public void setTheme(String theme) {
        this.theme = theme;
    }
    public Map<String, String> getLessVariables() {
        return lessVariables;
    }
    public void setLessVariables(Map<String, String> additionalThemeVariables) {
        this.lessVariables = additionalThemeVariables;
    }
    public Map<String, String> getCssVariables() {
        return cssVariables;
    }
    public void setCssVariables(Map<String, String> cssVariables) {
        this.cssVariables = cssVariables;
    }
    public List<String> getExtendCssUrls() {
        return extendCssUrls;
    }
    public void setExtendCssUrls(List<String> extendCssUrls) {
        this.extendCssUrls = extendCssUrls;
    }
}
