package com.bokesoft.yigo.ux.bootstarter.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import com.bokesoft.yigo.ux.bootstarter.data.additional.AdditionalThemeSetting;
import com.bokesoft.yigo.ux.defination.classic.config.UxSystemParameters;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultLoginDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultMainFrameDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultSiteDecoration;
import com.bokesoft.yigo.ux.defination.classic.navbar.NavbarOption;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionPackage;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionSetting;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavigationOption;
import com.bokesoft.yigo.ux.defination.common.themes.ThemeOption;

@Configuration
@ConfigurationProperties(prefix = "yigoee.tech.bootsupport.ux")
public class SpringUxConfigData {
    /** 是否完整模式. 在完整模式下, 会提供 Entry.xml 以在 Yigo 界面中提供相关管理菜单入口. 默认为 true. */
    private boolean fullMode = true;

    /** 使用的主题 */
    private ThemeOption themeOption;
    /** 使用的Mobile主题 */
    private ThemeOption themeOptionMobile;
    /** 使用的主菜单 */
    private NavbarOption navbarOption;

    /** Yigo 站点界面修饰 */
    private DefaultSiteDecoration site = new DefaultSiteDecoration();
    /** Yigo 登录界面修饰 */
    private DefaultLoginDecoration login = new DefaultLoginDecoration();
    /** Yigo 主界面框架修饰 */
    private DefaultMainFrameDecoration mainframe = new DefaultMainFrameDecoration();
    /** 导航栏区域定制 */
    private NavigationOption navigation = new NavigationOption();
    /** 主题相关的额外设置 */
    private List<AdditionalThemeSetting> additionalThemeSettings = new ArrayList<>();
    /** 导航栏区域的动作菜单配置, Key 为具体的 {@link NavActionPackage#name} */
    private Map<String, NavActionSetting> navActionSettings;

    /** 系统功能细节调整项 */
    private Features features = new Features();
    /** 系统参数 */
    private UxSystemParameters systemParameters = new UxSystemParameters();

    /** 前端自定义设置集合 */
    private Map<String, String> clientSettings = new LinkedHashMap<String, String>();

    /** 支持 Yigo 旧版本相关设置 */
    private OverrideYigoConfig overrideYigo = new OverrideYigoConfig();

    public boolean getFullMode() {
        return fullMode;
    }
    public void setFullMode(boolean fullMode) {
        this.fullMode = fullMode;
    }
    public ThemeOption getThemeOption() {
        return themeOption;
    }
    public void setThemeOption(ThemeOption themeOption) {
        this.themeOption = themeOption;
    }

    public ThemeOption getThemeOptionMobile() {
        return themeOptionMobile;
    }

    public void setThemeOptionMobile(ThemeOption themeOptionMobile) {
        this.themeOptionMobile = themeOptionMobile;
    }
    public NavbarOption getNavbarOption() {
        return navbarOption;
    }
    public void setNavbarOption(NavbarOption navbarOption) {
        this.navbarOption = navbarOption;
    }
    public DefaultSiteDecoration getSite() {
        return site;
    }
    public void setSite(DefaultSiteDecoration site) {
        this.site = site;
    }
    public DefaultLoginDecoration getLogin() {
        return login;
    }
    public void setLogin(DefaultLoginDecoration login) {
        this.login = login;
    }
    public DefaultMainFrameDecoration getMainframe() {
        return mainframe;
    }
    public void setMainframe(DefaultMainFrameDecoration mainframe) {
        this.mainframe = mainframe;
    }
    public NavigationOption getNavigation() {
        return navigation;
    }
    public void setNavigation(NavigationOption navigation) {
        this.navigation = navigation;
    }
    public List<AdditionalThemeSetting> getAdditionalThemeSettings() {
        return additionalThemeSettings;
    }
    public void setAdditionalThemeSettings(List<AdditionalThemeSetting> additionalThemeSettings) {
        this.additionalThemeSettings = additionalThemeSettings;
    }
    public Map<String, NavActionSetting>  getNavActionSettings() {
        return navActionSettings;
    }
    public void setNavActionSettings(Map<String, NavActionSetting>  navActionSettings) {
        this.navActionSettings = navActionSettings;
    }
    public Features getFeatures() {
        return features;
    }
    public void setFeatures(Features features) {
        this.features = features;
    }
    public UxSystemParameters getSystemParameters() {
        return systemParameters;
    }
    public void setSystemParameters(UxSystemParameters systemParameters) {
        this.systemParameters = systemParameters;
    }
    public Map<String, String> getClientSettings() {
        return clientSettings;
    }
    public void setClientSettings(Map<String, String> clientSettings) {
        this.clientSettings = clientSettings;
    }
    public OverrideYigoConfig getOverrideYigo() {
        return overrideYigo;
    }
    public void setOverrideYigo(OverrideYigoConfig override) {
        this.overrideYigo = override;
    }

    public static boolean useAdminConfigData(boolean fullMode, Features features){
        if (null==features || null==features.getUseAdminConfigData()){
            //未配置 useAdminConfigData, 则根据是否 fullMode 确定
            if (fullMode){
                return true;
            }else{
                return false;
            }
        }else{
            return features.getUseAdminConfigData();
        }
    }

    /**
     * 为了支持 Yigo 旧版本, 使用当前模块内置的 public/ 以及 yesui/dist/css/default/ 下必要的资源
     */
    public static class OverrideYigoConfig {
        private boolean enabled = false;

        public boolean isEnabled() {
            return enabled;
        }
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    /*
     * 系统功能细节调整项
     */
    public static class Features {
        /** 是否使用系统内置的 界面风格管理 数据. 默认为 null, 此时受 {@link SpringUxConfigData#fullMode} 控制. */
        private Boolean useAdminConfigData = null;

        public Boolean getUseAdminConfigData() {
            return useAdminConfigData;
        }
        public void setUseAdminConfigData(Boolean useAdminConfigData) {
            this.useAdminConfigData = useAdminConfigData;
        }
    }
}
