package com.bokesoft.yigo.ux.bootstarter.configer.features;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Component;

import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.ux.bootstarter.data.SpringUxConfigData;
import com.bokesoft.yigo.ux.bootstarter.yigoext.mid.UxSettingCache;
import com.bokesoft.yigo.ux.defination.classic.YigoClassicUxSetting;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultLoginDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultMainFrameDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultSiteDecoration;
import com.bokesoft.yigo.ux.intf.ext.IClassicDecorationProvider;

/**
 * 处理内置的"界面风格管理"字典数据(V_UX_AdminConfig), 实现管理员可自定义的界面风格. <br/>
 * - 可以被 {@link SpringUxConfigData#getFullMode()} 和 {@link SpringUxConfigData#getFeatures()} 配置项启用/停用; <br/>
 * - 同时如果有额外的 {@link IClassicDecorationProvider} 类型的 Bean 时, 将自动禁用.
 */
@Component
@ConditionalOnSingleCandidate(IClassicDecorationProvider.class)
public class BuildinAdminConfigDataDecorationProvider implements IClassicDecorationProvider {
    @Autowired
    private SpringUxConfigData configData;

    @Override
    public DefaultLoginDecoration getLoginDecoration(DefaultContext context) {
        if (SpringUxConfigData.useAdminConfigData(configData.getFullMode(), configData.getFeatures())){
            YigoClassicUxSetting ux = UxSettingCache.getDBUxSetting();
            return ux.getLoginDecoration();
        }else{
            return null;
        }
    }

    @Override
    public DefaultMainFrameDecoration getMainFrameDecoration(DefaultContext context) {
        if (SpringUxConfigData.useAdminConfigData(configData.getFullMode(), configData.getFeatures())){
            YigoClassicUxSetting ux = UxSettingCache.getDBUxSetting();
            return ux.getMainFrameDecoration();    
        }else{
            return null;
        }
    }

    @Override
    public DefaultSiteDecoration getSiteDecoration(DefaultContext context) {
        if (SpringUxConfigData.useAdminConfigData(configData.getFullMode(), configData.getFeatures())){
            YigoClassicUxSetting ux = UxSettingCache.getDBUxSetting();
            return ux.getSiteDecoration();    
        }else{
            return null;
        }
    }

}
