package com.bokesoft.yigo.ux.bootstarter.configer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoClientPageVariableProvider;
import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.ConfigerContext;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext.PageClass;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoPagesConfig;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoPagesConfig.DefaultPageResourceLocations;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.yigo.ux.bootstarter.data.SpringUxConfigData;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringUxEventListenerProvider;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringUxPackageProvider;
import com.bokesoft.yigo.ux.bootstarter.impl.SpringWebUxSettingProvider;
import com.bokesoft.yigo.ux.bootstarter.yigoext.mid.UxSettingService;
import com.bokesoft.yigo.ux.defination.classic.YigoClassicUxSetting;
import com.bokesoft.yigo.ux.defination.mobile.YigoMobileUxSetting;
import com.bokesoft.yigo.ux.impl.DefaultUxFactory;
import com.bokesoft.yigo.ux.intf.ext.IClassicDecorationProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxPackageProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxSettingProvider;
import com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.model.StaticReferenceIndicator;

@Configuration
public class UxConfiger {
    /**默认ignore solution文件*/
    private static String[] DEFAULT_IGNORE_RESOURCES = new String[]{"/yigo-ux-default-project/Entry.xml"};
    private static final Logger log = LoggerFactory.getLogger(UxConfiger.class);

    @Autowired
    private ApplicationContext appCtx;

    @Autowired
    private SpringUxConfigData configData;

    @Autowired
    private YigoPagesConfig pagesConfig;

    @Autowired
    private YigoInstanceManager yigoInstanceManager;

    @Autowired
    private List<IClassicDecorationProvider> additionalDecorationProviders;

    /**
     * 将Spring默认额UxSetting注入到UxSettingService中
     */
    @Autowired
    public void setSpringUxCofnigData2Service(SpringUxConfigData configData) {
        UxSettingService.setSpringCfgUxConfigData(configData);
    }

    @Bean("yigoUX_initDefaultUxFactory")
    public DefaultUxFactory yigoUX_initDefaultUxFactory() throws IOException {
        DefaultUxFactory.setup(new SpringUxEventListenerProvider(appCtx), configData.getSystemParameters());

        IUxPackageProvider pp = new SpringUxPackageProvider(appCtx);
        DefaultUxFactory.setUxPackageProvider(pp);

        IUxSettingProvider sp = new SpringWebUxSettingProvider(configData, appCtx, additionalDecorationProviders);
        DefaultUxFactory.setUxSettingProvider(sp);

        return new DefaultUxFactory();
    }

    @Bean
    @DependsOn({ "yigoUX_initDefaultUxFactory" })
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_ClassicUxSetting() {
        return new YigoClientPageVariableProvider() {
            @Override
            public boolean support(PageBuildContext ctx) {
                return PageClass.LOGIN == ctx.getPageClass() || PageClass.MAINFRAME == ctx.getPageClass()
                        || PageClass.WAITING == ctx.getPageClass();
            }

            @Override
            public Map<String, Object> getVariables(PageBuildContext ctx) {
                IUxSettingProvider uxSettingProvider = DefaultUxFactory.getUxSettingProvider();
                Map<String, Object> result = new HashMap<>();
                YigoClassicUxSetting uxSetting = uxSettingProvider.getClassicUxSetting(ctx.getDefaultContext());
                result.put(YigoClassicUxSetting.class.getSimpleName(), uxSetting);
                return result;
            }
        };
    }

    @Bean
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_MobileUxSetting() {
        return new YigoClientPageVariableProvider() {
            @Override
            public boolean support(PageBuildContext ctx) {
                return PageClass.APPHOME == ctx.getPageClass();
            }
            @Override
            public Map<String, Object> getVariables(PageBuildContext ctx) {
                IUxSettingProvider uxSettingProvider = DefaultUxFactory.getUxSettingProvider();
                Map<String, Object> result = new HashMap<>();
                YigoMobileUxSetting uxMobileSetting = uxSettingProvider.getMobileUxSetting(ctx.getDefaultContext());
                result.put(YigoMobileUxSetting.class.getSimpleName(), uxMobileSetting);
                return result;
            }
        };
    }

    //FIXME 此处实现最终需要移到 boot-support
    @Bean
    public YigoClientPageVariableProvider yigoUX_getYigoClientPageVariableProvider_InstanceStatue(){
        return new YigoClientPageVariableProvider(){
            @Override
            public boolean support(PageBuildContext ctx) {
                return PageClass.LOGIN == ctx.getPageClass() || PageClass.WAITING == ctx.getPageClass();
            }

            @Override
            public Map<String, Object> getVariables(PageBuildContext pageBuildContext) {
                Map<String, Object> result = new HashMap<>();
                result.put(InstanceStatus.class.getSimpleName(), yigoInstanceManager.getInstanceStatus());
                return result;
            }
        };
    }

    @Bean
	public YigoRawConfiger yigoUX_addYigoUxDefaultSolution() {
        final List<String> ignoreSources = new ArrayList<>();
        if (!configData.getFullMode()) {
            ignoreSources.addAll(Arrays.asList(DEFAULT_IGNORE_RESOURCES));
        }

        return new YigoRawConfiger() {
            @Override
			public void prepare(ConfigerContext context) {
				context.addSolution("yigo-ux-default-solution",
						SpringResourceMultiSolutionMetaResolverFactory.class,
						SpringResourceMultiSolutionMetaResolverFactory
								.buildParas("classpath:/yigo-ux-default-solution", ignoreSources));
			}
		};
	}

    @Bean
    public StaticReferenceIndicator yigoUX_buildDefaultStaticReferenceIndicator(){
        return new StaticReferenceIndicator(
            new String[]{
                "/yesui/ux/**"
            },
            new String[]{
                "classpath*:/webapps/yigo/yesui/ux/**"
            },
            new String[]{
                "**/lib/less.js/**"
            }
        );
    }

    @Bean
    public StaticReferenceIndicator yigoUX_buildOverrideStaticReferenceIndicators() {
        //补充 override-yigo-webapps 下的资源
        return new StaticReferenceIndicator(
            new String[]{
                "/yesui/ux/**",
                "/yesui/home/**"
            },
            new String[]{
                "classpath*:/override-yigo-webapps/yigo/yesui/ux/**",
                "classpath*:/override-yigo-webapps/yigo/yesui/home/**"
            },
            new String[]{
                "**/lib/less.js/**"
            }
        );
    }


    /**
     * 如果启用了 override.enabled = true, 覆盖默认的 default-page-resource-locations 设置值
     */
    @PostConstruct
    public void initVariableProviderSettings(){
        boolean overrideEnabled = configData.getOverrideYigo().isEnabled();
        if (!overrideEnabled){
            return;
        }

        //FIXME 此处的逻辑处理调用了 boot-support 的内部 API, 以后需要改进
        DefaultPageResourceLocations sysDefaultLocs = DefaultPageResourceLocations.buildDefault();
        String sysLoginLoc = sysDefaultLocs.getLogin();
        String sysMainframeLoc = sysDefaultLocs.getMainframe();
        String sysWaitingLoc = sysDefaultLocs.getWaiting();

        DefaultPageResourceLocations prLocs = pagesConfig.getDefaultPageResourceLocations();
        String loginLoc = prLocs.getLogin();
        if (StringUtils.equals(loginLoc, sysLoginLoc)){
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/login.html";
            prLocs.setLogin(overrideVal);
            log.info("启用 ux.override.enabled, Login 页面资源设置变化 {} -> {} .", sysLoginLoc, overrideVal);
        }
        String mainframeLoc = pagesConfig.getDefaultPageResourceLocations().getMainframe();
        if (StringUtils.equals(mainframeLoc, sysMainframeLoc)){
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/mainframe.html";
            prLocs.setMainframe(overrideVal);
            log.info("启用 ux.override.enabled, Mainframe 页面资源变化 {} -> {} .", sysMainframeLoc, overrideVal);
        }
        String waitingLoc = pagesConfig.getDefaultPageResourceLocations().getWaiting();
        if (StringUtils.equals(waitingLoc, sysWaitingLoc)){
            String overrideVal = "classpath:/override-yigo-webapps/yigo/ux-temp-resources/login.html";
            prLocs.setWaiting(overrideVal);
            log.info("启用 ux.override.enabled, Waiting 页面资源变化 {} -> {} .", sysWaitingLoc, overrideVal);
        }
    }
}
