/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.commons.slnbase.service.right.util;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.RightType;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jodd.util.Wildcard;

public class RightCacheUtil {
    private static ICache RIGHT_CACHE = CacheFactory.getInstance().createCache(RightCacheUtil.class.getName());
    private static String CACHE_PREFIX = "YIGO_RIGHT_CACHE";
    private static final String JOIN_SYMBOL = "#";

    public static <T> void setCache(String cacheKey, T obj) {
        RIGHT_CACHE.put(cacheKey, obj);
    }

    public static <T> T getCache(String cacheKey) {
        return (T)RIGHT_CACHE.get(cacheKey);
    }

    public static boolean contains(String cacheKey) {
        return RIGHT_CACHE.contains(cacheKey);
    }

    public static String buildCacheKey(TargetType targetType, RightType rightType, Long relatedId, String relatedKey, String viewUUID, String clientID) {
        CachePart cachePart = new CachePart(targetType, rightType, relatedId, relatedKey, viewUUID, clientID);
        return CACHE_PREFIX + JOIN_SYMBOL + cachePart.toString();
    }

    public static Map<String, FormRight> getFormRights(DefaultContext ctx, TargetType targetType, Long relatedId) {
        Set cacheKeys = RIGHT_CACHE.getKeys();
        HashMap<String, FormRight> formRights = new HashMap<String, FormRight>(64);
        String clientId = ctx.getVE().getClientID();
        String pattern = RightCacheUtil.buildCacheKey(targetType, RightType.FORM, relatedId, "*", "*", clientId);
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if (Wildcard.matchOne((String)cacheKey, (String[])new String[]{pattern}) <= -1) continue;
                CachePart cachePart = RightCacheUtil.buildCachePart(cacheKey);
                formRights.put(cachePart.getRelatedKey(), (FormRight)RightCacheUtil.getCache(cacheKey));
            }
        }
        return formRights;
    }

    public static Map<String, DictRight> getDictRights(DefaultContext ctx, TargetType targetType, Long relatedId) {
        Set cacheKeys = RIGHT_CACHE.getKeys();
        HashMap<String, DictRight> dictRights = new HashMap<String, DictRight>(64);
        String clientId = ctx.getVE().getClientID();
        String pattern = RightCacheUtil.buildCacheKey(targetType, RightType.DICT, relatedId, "*", "*", clientId);
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if (Wildcard.matchOne((String)cacheKey, (String[])new String[]{pattern}) <= -1) continue;
                CachePart cachePart = RightCacheUtil.buildCachePart(cacheKey);
                dictRights.put(cachePart.getRelatedKey(), (DictRight)RightCacheUtil.getCache(cacheKey));
            }
        }
        return dictRights;
    }

    public static void clearCacheOffline() {
        Set cacheKeys = RIGHT_CACHE.getKeys();
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                String[] parts = cacheKey.split(JOIN_SYMBOL);
                String clientId = parts[6];
                ISessionInfo sessionInfo = SessionUtils.getLoginSession((String)clientId);
                if (sessionInfo != null) continue;
                RIGHT_CACHE.remove(cacheKey);
            }
        }
    }

    public static void clearCacheByViewId(String clientId, String viewId) {
        Set cacheKeys = RIGHT_CACHE.getKeys();
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if (cacheKey.indexOf(viewId) <= -1 || cacheKey.indexOf(clientId) <= -1) continue;
                RIGHT_CACHE.remove(cacheKey);
            }
        }
    }

    private static CachePart buildCachePart(String cacheKey) {
        String[] parts = cacheKey.split(JOIN_SYMBOL);
        TargetType targetType = TargetType.valueOf(parts[1]);
        RightType rightType = RightType.valueOf(parts[2]);
        Long relatedId = Long.parseLong(parts[3]);
        String relatedKey = parts[4];
        String viewUUID = parts[5];
        String clientID = parts[6];
        CachePart cachePart = new CachePart(targetType, rightType, relatedId, relatedKey, viewUUID, clientID);
        return cachePart;
    }

    private static class CachePart {
        private Long relatedId;
        private TargetType targetType;
        private RightType rightType;
        private String viewUUID;
        private String relatedKey;
        private String clientID;

        public CachePart(TargetType targetType, RightType rightType, Long relatedId, String relatedKey, String viewUUID, String clientID) {
            this.targetType = targetType;
            this.rightType = rightType;
            this.relatedId = relatedId;
            this.viewUUID = viewUUID;
            this.relatedKey = relatedKey;
            this.clientID = clientID;
        }

        public TargetType getTargetType() {
            return this.targetType;
        }

        public RightType getRightType() {
            return this.rightType;
        }

        public String getViewUUID() {
            return this.viewUUID;
        }

        public String getRelatedKey() {
            return this.relatedKey;
        }

        public String getClientID() {
            return this.clientID;
        }

        public Long getRelatedId() {
            return this.relatedId;
        }

        public String toString() {
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(this.targetType.name());
            parts.add(this.rightType.name());
            parts.add(this.relatedId.toString());
            parts.add(this.relatedKey);
            parts.add(this.viewUUID);
            parts.add(this.clientID);
            return String.join((CharSequence)RightCacheUtil.JOIN_SYMBOL, parts);
        }
    }
}

