package com.bokesoft.yigo.commons.slnbase.service.right.excel;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.mid.rights.cache.RightsCacheFactory;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.utils.RightsDataUtil;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RoleRightsDataImportSerivce implements IImportService2 {

    private final String SQL_DELETE_ROLEOPTRIGHTS = "DELETE FROM SYS_RoleOptRights where RoleID=?";

    private final String SQL_UPDATE_ROLEOPTRIGHTS_PRE = "INSERT INTO SYS_RoleOptRights (FormKey, OptKey,RoleID) VALUES ";

    private final String SQL_DELETE_ROLEFIELDRIGHTS = "DELETE FROM SYS_RoleFieldRights where RoleID=?";

    private final String SQL_UPDATE_ROLEFIELDRIGHTS_PRE = "INSERT INTO SYS_RoleFieldRights (FormKey,FieldKey,Visible,Enable,RoleID) VALUES ";

    private final String SQL_DELETE_ROLEENTRYRIGHTS = "DELETE FROM SYS_RoleEntryRights where RoleID=?";

    private final String SQL_UPDATE_ROLEENTRYRIGHTS_PRE = "INSERT INTO SYS_RoleEntryRights (EntryKey,RoleID) VALUES ";

    private final String SQL_DELETE_ROLEDICTRIGHTS = "DELETE FROM ${TABLE_RR} where RoleID=?";

    private final String SQL_UPDATE_ROLEDICTRIGHTS_PRE = "INSERT INTO ${TABLE_RR} (DictID,RoleID) VALUES";

    @Override
    public Object importData(DefaultContext context, byte[] bytes) throws Throwable {
        long roleID = TypeConvertor.toLong(context.getPara("RoleOID"));
        if (roleID == 0) {
            throw new Exception("没有选择角色！");
        }
        RightsData rightsData = RightsDataUtil.getRightsData(context);
        InputStream is = new ByteArrayInputStream(bytes);
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(is);
        _fillRoleRightsData4Entry2DB(context, xssfWorkbook, roleID);
        _fillRoleRightsData4EntryOpt2DB(context, xssfWorkbook, roleID);
        _fillRoleRightsData4EntryField2DB(context, xssfWorkbook, roleID);
        _fillRoleRightsData4Dict2DB(context, xssfWorkbook, rightsData, roleID);
        return null;
    }

    private void _fillRoleRightsData4Dict2DB(DefaultContext context, XSSFWorkbook xssfWorkbook, RightsData rightsData,
                                             long roleID) throws Throwable {

        Sheet sheet = ExcelUtil.getSheet(xssfWorkbook, "数据权限");
        String dbTalbe = "";
        String dictKey = "";
        StringBuffer updateSqlbf = null;
        List<Object> args = new ArrayList<Object>();
        for (int rowIdx = 1; rowIdx <= sheet.getLastRowNum(); rowIdx++) {
            if (!dbTalbe.equals(ExcelUtil.getCellValue(sheet, rowIdx, 3).toString())) {
                if (null != updateSqlbf && args.size() > 0) {
                    context.getDBManager().execPrepareUpdate(SQL_DELETE_ROLEDICTRIGHTS.replace("${TABLE_RR}", dbTalbe)
                            , roleID);
                    context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                    RightsCacheFactory.getInstance().createRoleRightsCache().clearDictRights(roleID, dictKey);
                }
                dictKey = ExcelUtil.getCellValue(sheet, rowIdx, 1).toString();
                dbTalbe = ExcelUtil.getCellValue(sheet, rowIdx, 3).toString();
                updateSqlbf = new StringBuffer(SQL_UPDATE_ROLEDICTRIGHTS_PRE.replace("${TABLE_RR}", dbTalbe));
                args.clear();
            }
            if (args.size() > 900) {
                context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                updateSqlbf = new StringBuffer(SQL_UPDATE_ROLEDICTRIGHTS_PRE.replace("${TABLE_RR}", dbTalbe));
                args.clear();
            }
            updateSqlbf.append("(?,?),");
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 4).toString());
            args.add(roleID);
        }
        RightsCacheFactory.getInstance().createRoleRightsCache().clearDictRights(roleID, dictKey);
        context.getDBManager().execPrepareUpdate(SQL_DELETE_ROLEDICTRIGHTS.replace("${TABLE_RR}", dbTalbe)
                , roleID);
        context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
    }

    private void _fillRoleRightsData4EntryField2DB(DefaultContext context, XSSFWorkbook xssfWorkbook, long roleID)
            throws Throwable {
        context.getDBManager().execPrepareUpdate(SQL_DELETE_ROLEFIELDRIGHTS, roleID);
        Sheet sheet = ExcelUtil.getSheet(xssfWorkbook, "角色字段权限");
        StringBuffer updateSqlbf = new StringBuffer(SQL_UPDATE_ROLEFIELDRIGHTS_PRE);
        List<Object> args = new ArrayList<Object>();
        for (int rowIdx = 1; rowIdx <= sheet.getLastRowNum(); rowIdx++) {
            updateSqlbf.append("(?,?,?,?,?),");
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 0).toString());
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 1).toString());
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 2).toString());
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 3).toString());
            args.add(roleID);
        }
        context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
    }

    private void _fillRoleRightsData4EntryOpt2DB(DefaultContext context, XSSFWorkbook xssfWorkbook, long roleID) throws Throwable {
        context.getDBManager().execPrepareUpdate(SQL_DELETE_ROLEOPTRIGHTS, roleID);
        Sheet sheet = ExcelUtil.getSheet(xssfWorkbook, "角色权限操作");
        StringBuffer updateSqlbf = new StringBuffer(SQL_UPDATE_ROLEOPTRIGHTS_PRE);
        List<Object> args = new ArrayList<Object>();
        for (int rowIdx = 1; rowIdx <= sheet.getLastRowNum(); rowIdx++) {
            updateSqlbf.append("(?,?,?),");
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 0).toString());
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 1).toString());
            args.add(roleID);
            RightsCacheFactory.getInstance().createRoleRightsCache().clearFormRights(roleID, ExcelUtil.getCellValue(sheet, rowIdx, 0).toString());
        }
        context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
    }

    private void _fillRoleRightsData4Entry2DB(DefaultContext context, XSSFWorkbook xssfWorkbook, long roleID) throws Throwable {
        context.getDBManager().execPrepareUpdate(SQL_DELETE_ROLEENTRYRIGHTS, roleID);
        Sheet sheet = ExcelUtil.getSheet(xssfWorkbook, "角色入口权限");
        StringBuffer updateSqlbf = new StringBuffer(SQL_UPDATE_ROLEENTRYRIGHTS_PRE);
        List<Object> args = new ArrayList<Object>();
        for (int rowIdx = 1; rowIdx <= sheet.getLastRowNum(); rowIdx++) {
            updateSqlbf.append("(?,?),");
            args.add(ExcelUtil.getCellValue(sheet, rowIdx, 0).toString());
            args.add(roleID);
        }
        RightsCacheFactory.getInstance().createRoleRightsCache().clearEntryRights(roleID);
        context.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
    }

    @Override
    public void setFormKey(String formKey) {
        // doNothing
    }

    @Override
    public void setClearOriginalData(boolean clearOriginalData) {
        // doNothing
    }

    @Override
    public void setPostServiceName(String postServiceName) {
        // doNothing
    }
}
