package com.bokesoft.yigo.commons.slnbase.service.configurer;

import org.springframework.stereotype.Component;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.ConfigerContext;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.yigo.commons.slnbase.service.config.SlnBaseConfig;

@Component
public class SolutionsConfigurer implements YigoRawConfiger {
    private final SlnBaseConfig slnBaseConfig;

    public SolutionsConfigurer(SlnBaseConfig slnBaseConfig){
        this.slnBaseConfig = slnBaseConfig;
    }

    @Override
    public void prepare(ConfigerContext context) {
        if (! slnBaseConfig.isIgnoreBuildinBootSolution()){
            context.addSolution("sln-yigo-commons-sln-boot", true,
                SpringResourceMultiSolutionMetaResolverFactory.class,
                SpringResourceMultiSolutionMetaResolverFactory.buildParas(
                    slnBaseConfig.getBootSolutionLocation()));
        }
        if (! slnBaseConfig.isIgnoreBuildinBaseSolution()){
            context.addSolution("sln-yigo-commons-sln-base",
            SpringResourceMultiSolutionMetaResolverFactory.class,
            SpringResourceMultiSolutionMetaResolverFactory.buildParas(
                slnBaseConfig.getBaseSolutionLocation(), slnBaseConfig.getIgnoreBaseResources()));
        }
    }
}
