/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.commons.slnbase.service.right.util;

import com.bokesoft.yes.mid.server.ServiceRequest;
import com.bokesoft.yes.mid.server.ServiceResponse;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.server.IServiceRequest;
import com.bokesoft.yigo.mid.server.IServiceResponse;
import com.bokesoft.yigo.mid.server.dispatcher.util.ServiceUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.env.Env;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class RightUtil {
    private static final Long ADMIN_USER_ID = 21L;
    private static final Long ADMIN_ROLE_ID = 11L;

    public static EntryRightData loadEntryRights(DefaultContext context, long roleID, long operatorID) throws Throwable {
        ServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put((Object)"service", (Object)"SetRightsService");
        req.getParameterMap().put((Object)"cmd", (Object)"LoadEntryRightsData");
        req.getParameterMap().put((Object)"operatorID", (Object)operatorID);
        req.getParameterMap().put((Object)"roleID", (Object)roleID);
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher((IServiceRequest)req).processService((IServiceRequest)req, (IServiceResponse)resp);
        JSONObject obj = (JSONObject)resp.getResult();
        JSONObject data = (JSONObject)obj.get("data");
        ObjectMapper m = new ObjectMapper();
        EntryRightData rightsData = (EntryRightData)m.readValue(data.toString(), EntryRightData.class);
        return rightsData;
    }

    public static FormRightsData loadFormRights(DefaultContext context, String formKey, long roleID, long operatorID) throws Throwable {
        ServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put((Object)"service", (Object)"SetRightsService");
        req.getParameterMap().put((Object)"cmd", (Object)"LoadFormRightsData");
        req.getParameterMap().put((Object)"formKey", (Object)formKey);
        req.getParameterMap().put((Object)"operatorID", (Object)operatorID);
        req.getParameterMap().put((Object)"roleID", (Object)roleID);
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher((IServiceRequest)req).processService((IServiceRequest)req, (IServiceResponse)resp);
        JSONObject obj = (JSONObject)resp.getResult();
        JSONObject data = (JSONObject)obj.get("data");
        ObjectMapper m = new ObjectMapper();
        FormRightsData formRightsData = (FormRightsData)m.readValue(data.toString(), FormRightsData.class);
        return formRightsData;
    }

    public static boolean isAdmin(DefaultContext ctx) {
        Env env = ctx.getVE().getEnv();
        List roleIDList = env.getRoleIDList();
        Long userId = env.getUserID();
        return ADMIN_USER_ID.equals(userId) || roleIDList.contains(ADMIN_ROLE_ID);
    }

    public static DictRight loadDictRightsData(DefaultContext ctx, String itemKey, long roleID, long operatorID) throws Throwable {
        DataTable dictDataDT;
        DictRight dictRight = new DictRight();
        dictRight.setItemKey(itemKey);
        dictRight.setHasEmptRights(false);
        dictRight.setHasAllRights(false);
        IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
        MetaDataObject metaDataObject = metaFactory.getDataObject(itemKey);
        String dbTable = metaDataObject.getMainTable().getBindingDBTableName();
        ArrayList<Number> args = new ArrayList<Number>();
        String sql = "SELECT OID,ParentId,Code,Name FROM " + dbTable + " WHERE 1=? ";
        args.add(1);
        List<Long> curDictRightOIDs = RightUtil.getDictOIDsByCurRight(ctx, dbTable);
        if (curDictRightOIDs.size() <= 0) {
            return dictRight;
        }
        Long fOID = curDictRightOIDs.get(0);
        if (fOID != -1L) {
            sql = sql + " AND OID IN(" + StringUtils.join(Collections.nCopies(curDictRightOIDs.size(), "?"), (String)",") + ")";
            args.addAll(curDictRightOIDs);
        }
        if ((dictDataDT = ctx.getDBManager().execPrepareQuery(sql, args)).size() > 0) {
            List<Long> rightDictIds = RightUtil.getDictOIDsByRoleOrOperator(ctx, dbTable, roleID, operatorID);
            if (rightDictIds.contains(-1L)) {
                dictRight.setHasAllRights(true);
            }
            if (rightDictIds.contains(0L)) {
                dictRight.setHasEmptRights(true);
            }
            dictRight.setDataList(new ArrayList<DictRight.Data>());
            dictDataDT.beforeFirst();
            while (dictDataDT.next()) {
                DictRight.Data data = new DictRight.Data();
                data.setParentId(dictDataDT.getLong("ParentId"));
                data.setOid(dictDataDT.getLong("OID"));
                data.setCode(dictDataDT.getString("Code"));
                data.setName(dictDataDT.getString("Name"));
                if (dictRight.isHasAllRights() || rightDictIds.contains(data.getOid())) {
                    data.setDataRight(true);
                } else {
                    data.setDataRight(false);
                }
                dictRight.getDataList().add(data);
            }
        }
        return dictRight;
    }

    private static List<Long> getDictOIDsByRoleOrOperator(DefaultContext ctx, String dictTableName, long roleID, long operatorID) throws Throwable {
        DataTable dataTable = null;
        if (roleID > 0L) {
            dataTable = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_RR WHERE RoleId=?", new Object[]{roleID});
        } else if (operatorID > 0L) {
            dataTable = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_OR WHERE OperatorId=?", new Object[]{operatorID});
        }
        ArrayList<Long> dictIds = new ArrayList<Long>();
        if (dataTable != null) {
            dataTable.beforeFirst();
            while (dataTable.next()) {
                dictIds.add(dataTable.getLong("DictID"));
            }
        }
        return dictIds;
    }

    private static List<Long> getDictOIDsByCurRight(DefaultContext ctx, String dictTableName) throws Throwable {
        List roleIDList;
        ArrayList<Long> ids = new ArrayList<Long>();
        if (RightUtil.isAdmin(ctx)) {
            ids.add(-1L);
            return ids;
        }
        Env env = ctx.getEnv();
        Long userId = env.getUserID();
        DataTable dictDataDT = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_OR WHERE OperatorID=?", new Object[]{userId});
        if (dictDataDT != null && dictDataDT.size() > 0) {
            dictDataDT.beforeFirst();
            while (dictDataDT.next()) {
                Long dictID = dictDataDT.getLong("DictID");
                if (dictID == -1L) {
                    ids.clear();
                    ids.add(-1L);
                    return ids;
                }
                ids.add(dictID);
            }
        }
        if ((roleIDList = env.getRoleIDList()) != null && roleIDList.size() > 0) {
            ArrayList args = new ArrayList(roleIDList);
            DataTable dictRoleRightDT = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_RR WHERE RoleId IN (" + StringUtils.join(Collections.nCopies(roleIDList.size(), "?"), (String)",") + ")", args);
            if (dictRoleRightDT.size() > 0) {
                dictRoleRightDT.beforeFirst();
                while (dictRoleRightDT.next()) {
                    Long dictID = dictRoleRightDT.getLong("DictID");
                    if (dictID == -1L) {
                        ids.clear();
                        ids.add(-1L);
                        return ids;
                    }
                    ids.add(dictID);
                }
            }
        }
        return ids;
    }

    public static SetRight getSetRightsData(DefaultContext context) throws Throwable {
        ServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put((Object)"service", (Object)"SetRightsService");
        req.getParameterMap().put((Object)"cmd", (Object)"LoadSetRightsList");
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher((IServiceRequest)req).processService((IServiceRequest)req, (IServiceResponse)resp);
        JSONObject obj = (JSONObject)resp.getResult();
        JSONObject data = (JSONObject)obj.get("data");
        ObjectMapper m = new ObjectMapper();
        SetRight rightsData = (SetRight)m.readValue(data.toString(), SetRight.class);
        return rightsData;
    }

    public static FormRight buildFormRightByDoc(Document document) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable operationsDT = document.get("YES_RS_Operations");
        DataTable fieldRightsDT = document.get("YES_RS_FieldRights");
        FormRight formRight = new FormRight();
        if (headDT.first()) {
            formRight.setFormKey(headDT.getString("FormKey"));
            formRight.setHasAllEnableRights(headDT.getInt("All_IsEdit") == 1);
            formRight.setHasAllOptRights(headDT.getInt("All_O") == 1);
            formRight.setHasAllVisibleRights(headDT.getInt("All_IsVisible") == 1);
        }
        if (operationsDT != null) {
            formRight.setOpt(new ArrayList<FormRight.Opt>());
            operationsDT.beforeFirst();
            while (operationsDT.next()) {
                FormRight.Opt opt = new FormRight.Opt();
                opt.setId(operationsDT.getLong("OID"));
                opt.setParentId(operationsDT.getLong("ParentID"));
                opt.setName(operationsDT.getString("Name"));
                opt.setOptKey(operationsDT.getString("OptKey"));
                opt.setOpt(operationsDT.getInt("IsOpt") == 1);
                formRight.getOpt().add(opt);
            }
        }
        if (fieldRightsDT != null) {
            formRight.setField(new ArrayList<FormRight.Field>());
            fieldRightsDT.beforeFirst();
            while (fieldRightsDT.next()) {
                FormRight.Field field = new FormRight.Field();
                field.setEdit(fieldRightsDT.getInt("IsEdit") == 1);
                field.setVisible(fieldRightsDT.getInt("IsVisible") == 1);
                field.setFieldKey(fieldRightsDT.getString("FieldKey"));
                field.setId(fieldRightsDT.getLong("OID"));
                field.setParentId(fieldRightsDT.getLong("ParentID"));
                field.setName(fieldRightsDT.getString("Name"));
                formRight.getField().add(field);
            }
        }
        return formRight;
    }

    public static DictRight buildDictRightByDoc(Document document) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable dataRigthsDT = document.get("YES_RS_DataRigths");
        DictRight dictRight = new DictRight();
        if (headDT.isFirst()) {
            dictRight.setItemKey(headDT.getString("ItemKey"));
            dictRight.setHasAllRights(headDT.getInt("All_DataRight") == 1);
            dictRight.setHasEmptRights(headDT.getInt("Is_Null") == 1);
        }
        if (dataRigthsDT.size() > 0) {
            dictRight.setDataList(new ArrayList<DictRight.Data>());
            dataRigthsDT.beforeFirst();
            while (dataRigthsDT.next()) {
                DictRight.Data data = new DictRight.Data();
                data.setOid(dataRigthsDT.getLong("OID"));
                data.setParentId(dataRigthsDT.getLong("ParentId"));
                data.setCode(dataRigthsDT.getString("Code"));
                data.setName(dataRigthsDT.getString("Name"));
                data.setDataRight(dataRigthsDT.getInt("Is_DataRight") == 1);
                dictRight.getDataList().add(data);
            }
        }
        return dictRight;
    }

    public static void fillDictRight2Document(Document document, DictRight dictRight) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        if (headDT.first()) {
            headDT.setInt("All_DataRight", Integer.valueOf(dictRight.isHasAllRights() ? 1 : 0));
            headDT.setInt("Is_Null", Integer.valueOf(dictRight.isHasEmptRights() ? 1 : 0));
        }
        DataTable dictRightsDT = document.get("YES_RS_DataRigths");
        dictRightsDT.clear();
        if (dictRight.getDataList() != null) {
            for (DictRight.Data data : dictRight.getDataList()) {
                dictRightsDT.append();
                dictRightsDT.setString("Name", data.getName());
                dictRightsDT.setString("Code", data.getCode());
                dictRightsDT.setInt("Is_DataRight", Integer.valueOf(data.isDataRight() ? 1 : 0));
                dictRightsDT.setLong("OID", data.getOid());
                dictRightsDT.setLong("ParentID", data.getParentId());
            }
        }
    }

    public static void fillFormRight2Document(Document document, FormRight formRight) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable operationsDT = document.get("YES_RS_Operations");
        DataTable fieldRightsDT = document.get("YES_RS_FieldRights");
        if (headDT.first()) {
            headDT.setInt("All_IsEdit", Integer.valueOf(formRight.isHasAllEnableRights() ? 1 : 0));
            headDT.setInt("All_O", Integer.valueOf(formRight.isHasAllOptRights() ? 1 : 0));
            headDT.setInt("All_IsVisible", Integer.valueOf(formRight.isHasAllVisibleRights() ? 1 : 0));
        }
        fieldRightsDT.clear();
        if (formRight.getField() != null) {
            for (FormRight.Field field : formRight.getField()) {
                fieldRightsDT.append();
                fieldRightsDT.setInt("IsEdit", Integer.valueOf(field.isEdit() ? 1 : 0));
                fieldRightsDT.setInt("IsVisible", Integer.valueOf(field.isVisible() ? 1 : 0));
                fieldRightsDT.setString("FieldKey", field.getFieldKey());
                fieldRightsDT.setLong("OID", field.getId());
                fieldRightsDT.setLong("ParentID", field.getParentId());
                fieldRightsDT.setString("Name", field.getName());
            }
        }
        operationsDT.clear();
        if (formRight.getOpt() != null) {
            for (FormRight.Opt opt : formRight.getOpt()) {
                operationsDT.append();
                operationsDT.setInt("IsOpt", Integer.valueOf(opt.isOpt() ? 1 : 0));
                operationsDT.setString("Name", opt.getName());
                operationsDT.setString("OptKey", opt.getOptKey());
            }
        }
    }

    public static void buildFormOptRightDT(List<FormRightsData.OptData> optDataList, DataTable optRightDT, Long parentID) {
        if (optDataList != null) {
            for (FormRightsData.OptData optData : optDataList) {
                long id = optData.getKey().hashCode();
                optRightDT.append();
                optRightDT.setLong("OID", Long.valueOf(id));
                optRightDT.setLong("ParentID", parentID);
                optRightDT.setString("OptKey", optData.getKey());
                optRightDT.setString("Name", optData.getCaption());
                optRightDT.setInt("IsOpt", Integer.valueOf(optData.isHasRights() ? 1 : 0));
                if (optData.getItems() == null) continue;
                RightUtil.buildFormOptRightDT(optData.getItems(), optRightDT, id);
            }
        }
    }

    public static void buildFormFieldRightDT(List<FormRightsData.FieldData> fieldDataList, DataTable fieldRightDT, Long parentID) {
        if (fieldDataList != null) {
            for (FormRightsData.FieldData fieldData : fieldDataList) {
                long id = fieldData.getKey().hashCode();
                fieldRightDT.append();
                fieldRightDT.setLong("OID", Long.valueOf(id));
                fieldRightDT.setString("Name", fieldData.getCaption());
                fieldRightDT.setString("FieldKey", fieldData.getKey());
                fieldRightDT.setInt("IsVisible", Integer.valueOf(fieldData.isVisible() ? 1 : 0));
                fieldRightDT.setInt("IsEdit", Integer.valueOf(fieldData.isEnable() ? 1 : 0));
                fieldRightDT.setLong("ParentID", parentID);
                if (fieldData.getItems() == null) continue;
                RightUtil.buildFormFieldRightDT(fieldData.getItems(), fieldRightDT, id);
            }
        }
    }

    public static void buildEntryRightDT(List<SetRight.Entry> entries, DataTable entryRightDT, long parentID) {
        if (entries != null) {
            for (SetRight.Entry entry : entries) {
                long oid = entry.getKey().hashCode();
                entryRightDT.append();
                entryRightDT.setLong("OID", Long.valueOf(oid));
                entryRightDT.setLong("ParentID", Long.valueOf(parentID));
                entryRightDT.setString("EntryName", entry.getCaption());
                entryRightDT.setString("EntryKey", entry.getKey());
                if (entry.getItems() == null) continue;
                RightUtil.buildEntryRightDT(entry.getItems(), entryRightDT, oid);
            }
        }
    }

    public static void buildDictRightsDT(List<SetRight.Dict> dict, DataTable dictRightsDT) {
        for (SetRight.Dict d : dict) {
            dictRightsDT.append();
            dictRightsDT.setString("Name", d.getCaption());
            dictRightsDT.setString("DictKey", d.getKey());
        }
    }

    public static void buildBillRightsDT(List<SetRight.Form> forms, DataTable billRightsDT) {
        for (SetRight.Form form : forms) {
            billRightsDT.append();
            billRightsDT.setString("Name", form.getCaption());
            billRightsDT.setString("FormKey", form.getKey());
        }
    }

    public static class SetRight {
        private List<Dict> dict;
        private List<Form> form;
        private List<Entry> entry;
        private Object custom;

        public List<Dict> getDict() {
            return this.dict;
        }

        public void setDict(List<Dict> dict) {
            this.dict = dict;
        }

        public List<Form> getForm() {
            return this.form;
        }

        public void setForm(List<Form> form) {
            this.form = form;
        }

        public List<Entry> getEntry() {
            return this.entry;
        }

        public void setEntry(List<Entry> entry) {
            this.entry = entry;
        }

        public Object getCustom() {
            return this.custom;
        }

        public void setCustom(Object custom) {
            this.custom = custom;
        }

        public static class Entry {
            private String caption;
            private List<Entry> items;
            private String key;
            private String rightsRelation;
            private String formCaption;
            private String formKey;

            public String getCaption() {
                return this.caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public List<Entry> getItems() {
                return this.items;
            }

            public void setItems(List<Entry> items) {
                this.items = items;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getRightsRelation() {
                return this.rightsRelation;
            }

            public void setRightsRelation(String rightsRelation) {
                this.rightsRelation = rightsRelation;
            }

            public String getFormCaption() {
                return this.formCaption;
            }

            public void setFormCaption(String formCaption) {
                this.formCaption = formCaption;
            }

            public String getFormKey() {
                return this.formKey;
            }

            public void setFormKey(String formKey) {
                this.formKey = formKey;
            }
        }

        public static class Form {
            private String caption;
            private Object serviceRights;
            private String key;

            public String getCaption() {
                return this.caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public Object getServiceRights() {
                return this.serviceRights;
            }

            public void setServiceRights(Object serviceRights) {
                this.serviceRights = serviceRights;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }
        }

        public static class Dict {
            private String caption;
            private Integer secondaryType;
            private String key;

            public String getCaption() {
                return this.caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public Integer getSecondaryType() {
                return this.secondaryType;
            }

            public void setSecondaryType(Integer secondaryType) {
                this.secondaryType = secondaryType;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }
        }
    }

    public static class FormRightsData {
        private boolean defStatus;
        private boolean hasAllEnableRights;
        private boolean hasAllOptRights;
        private boolean hasAllVisibleRights;
        private List<FieldData> fieldData;
        private List<OptData> optData;

        public boolean isDefStatus() {
            return this.defStatus;
        }

        public void setDefStatus(boolean defStatus) {
            this.defStatus = defStatus;
        }

        public boolean isHasAllEnableRights() {
            return this.hasAllEnableRights;
        }

        public void setHasAllEnableRights(boolean hasAllEnableRights) {
            this.hasAllEnableRights = hasAllEnableRights;
        }

        public boolean isHasAllOptRights() {
            return this.hasAllOptRights;
        }

        public void setHasAllOptRights(boolean hasAllOptRights) {
            this.hasAllOptRights = hasAllOptRights;
        }

        public boolean isHasAllVisibleRights() {
            return this.hasAllVisibleRights;
        }

        public void setHasAllVisibleRights(boolean hasAllVisibleRights) {
            this.hasAllVisibleRights = hasAllVisibleRights;
        }

        public List<FieldData> getFieldData() {
            return this.fieldData;
        }

        public void setFieldData(List<FieldData> fieldData) {
            this.fieldData = fieldData;
        }

        public List<OptData> getOptData() {
            return this.optData;
        }

        public void setOptData(List<OptData> optData) {
            this.optData = optData;
        }

        public static class OptData {
            private String caption;
            private boolean hasRights;
            private String key;
            private List<OptData> items;

            public String getCaption() {
                return this.caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public boolean isHasRights() {
                return this.hasRights;
            }

            public void setHasRights(boolean hasRights) {
                this.hasRights = hasRights;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public List<OptData> getItems() {
                return this.items;
            }

            public void setItems(List<OptData> items) {
                this.items = items;
            }
        }

        public static class FieldData {
            private String caption;
            private boolean enable;
            private String key;
            private boolean visible;
            private List<FieldData> items;

            public String getCaption() {
                return this.caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public boolean isEnable() {
                return this.enable;
            }

            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public boolean isVisible() {
                return this.visible;
            }

            public void setVisible(boolean visible) {
                this.visible = visible;
            }

            public List<FieldData> getItems() {
                return this.items;
            }

            public void setItems(List<FieldData> items) {
                this.items = items;
            }
        }
    }

    public static class EntryRightData {
        private boolean allRights;
        private List<String> entryKeys;

        public boolean isAllRights() {
            return this.allRights;
        }

        public void setAllRights(boolean allRights) {
            this.allRights = allRights;
        }

        public List<String> getEntryKeys() {
            return this.entryKeys;
        }

        public void setEntryKeys(List<String> entryKeys) {
            this.entryKeys = entryKeys;
        }
    }
}

