import mergeEntryBySameKey from "../util/mergeEntry.js";
import MainTree from "./maintree.js";
import { searchContainer } from "./menutree-search.js";
import Favorite from "../../home/js/favorite/favorite.js";
/**
 * 获取 window.location.hash || window.location.search 上的参数
 * @returns
 */
const getUrlParams = () => {
    const hash = window.location.hash ? window.location.hash.slice(1) : '';
    const urlSearch = new URLSearchParams(hash || window.location.search);
    let result = {};
    for (let key of urlSearch.keys()) {
        result[key] = urlSearch.get(key);
    }
    return result;
}

export default async function menuTree() {
    var mainTree = null;

    const entryData =  await YIUI.APP.MainFrame.getEntryData();
    var rootEntry = entryData.entry;
    mergeEntryBySameKey(rootEntry);
    var caption = entryData.caption;

    if (
        window.YigoClassicUxSetting &&
        window.YigoClassicUxSetting.mainFrameDecoration &&
        window.YigoClassicUxSetting.mainFrameDecoration.bannerTitleHtml
    ) {
        var captionTmpl =
            window.YigoClassicUxSetting.mainFrameDecoration.bannerTitleHtml;

        caption = captionTmpl.replace("${caption}", caption);
    }

    const logoTxtDom = document.createElement("span");
    logoTxtDom.classList.add("logo-text");
    logoTxtDom.innerHTML = caption || window.Yes_ENV_BrandName;
    YIUI.APP.MainFrame.appendDomToLeftNav(logoTxtDom);

    var _listbox = document.querySelector("#listBox");

    YIUI.MenuTree = {
        reload(){
            const forceGet = true; // 强行获取
            YIUI.APP.MainFrame.getEntryData("", forceGet).then(async result => {
                mergeEntryBySameKey(result.entry);
                await Favorite.addFavorites2MenuData(result.entry)
                mainTree.reload(result.entry);
                window.dispatchEvent(new CustomEvent('YES-MainFrame-entryReload', {
                    detail: {
                        entryData: result
                    }
                }));
            });
        }
    }

    mainTree = await new MainTree(rootEntry, _listbox);
    YIUI.MainTree = {
        ...(YIUI.MainTree || {}),
        mainTree
    };
    
    window.addEventListener("YES-MainFrame-callEntryReload", () => {
        YIUI.MenuTree.reload();
    });

    var metaService = new YIUI.MetaService();
    metaService.getPreLoadItems().then(function (items) {
        if (items) {
            for (var i = 0, len = items.length; i < len; i++) {
                YIUI.treeClickHandle(items[i]);
            }
        }
    });

    const urlParams = getUrlParams();
    if (urlParams && urlParams.FormKey) {
        YIUI.LoadingUtil.show();
        const { FormKey, OID, ...options } = urlParams;
        options.parameters = Object.assign(options.parameters || {}, options, { customOnLoad: true });
        YIUI.APP.MainFrame.openFormInNewTab(FormKey, OID, options).finally(()=>{
            YIUI.LoadingUtil.hide();
        });
    }

    // 载入菜单搜索
    YIUI.APP.MainFrame.appendDomToLeftSide(searchContainer, "before"); // position: before指在前面插入
}
