import "./fieldcontrols/index.js";
import FieldMapping from "./fieldmap.js";
import SystemFields from "./systemfieldtype.js";
/**
 * 扩展字段设置相关-入口
 */
export const extendedFieldsSetting = (extendedFields) => {

    const container = document.getElementsByClassName("login-loginbox")[0];
    const subbtn = container.querySelector('.login-button');
    /**
     * 渲染排序规则
     * 平台系统默认字段：用户名(username)，密码框(password)，多语言(language)，验证码(valid)。
     * 扩展字段优先，如果扩展字段没有配置任何的默认字段排序，默认放在用户名前面
     *     例如：
     *       情况1：
     *         扩展字段只有组织机构，则界面显示组织机构，用户名，密码框，多语言，验证码
     *       情况2：
     *         字段集合：用户名，密码框，组织机构
     *         界面显示：用户名，密码框，组织机构，多语言，验证码
     * 
     * 界面可见性规则：默认为null，ux字段配置可见性，按照配置来，没有配置，不予处理
     * 
     * 界面默认值: ux配置系统字段默认值时，可显示默认值(目前不考虑平台配置多语言的情况)
     * 
     * 界面显示方式：系统默认字段不会被ux重新渲染
     */

    /** 定义系统默认字段 */
    const defaultFields = SystemFields.getSystemFieldList();
    // 创建一个Set来保存extendedFields中的字段，去除重复项  
    const extendedFieldSet = new Set(extendedFields.map(obj => obj.key));
    // 创建一个新数组来保存最终的排序结果  
    const sortedFields = [...extendedFields];
    // 遍历defaultFields，将不在extendedFields中的字段添加到sortedFields数组的末尾  
    for (const field of defaultFields) {
        if (!extendedFieldSet.has(field)) {
            sortedFields.push({ key: field });
        }
    }
    sortedFields.forEach((field, index) => {
        field.container = container;
        field.subbtn = subbtn;
        field.tabIndex = index;
        if (defaultFields.includes(field.key)) {
            field.type = "DEFAULT";
        }
        field.impl = FieldMapping.getInstance().get(field);
        field.impl.render();
    });
}