import "./modulepreload-polyfill-7faf532e.js";
import { A as YesModalContainer, T as Tabs, L as LLMChatTrigger, B as LLMChat, b as YesVBaseComponent, C as ControlMapping, D as treeClickHandle, F as FormRenderUtil, E as YesOwnerDraw, c as YElement, s as h, M as MainContainerBuilder } from "./yes-ui-c6bba9c4.js";
import { q as ExceptionStack, bw as StatusProxy, bx as afterYIUILoad, by as UIOptTraceUtil, aB as MainUIOptTracer, bz as FormRender, bA as AppSetting, bd as MainFrameInterface, bB as LLMChatInterface, S as SvrMgr, K as I18N, bc as MainContainer, bC as SessionParasCache, bt as SessionInfo, _ as IconSourceLoader, bD as YesCore, w as ControlType, bE as CookiesUtil, j as FormBuilder, M as MetaService, s as FormTarget, O as OperationState, N as NewOpt, i as OptQueue, bF as RemoteService, k as FormStack, an as BaseDialog, a6 as GridSetting, h as FormType, bp as NotificationMgr, bG as MenuFavoriteService, bH as ViewParser, l as FuncMap, bI as DataService, aJ as DictService, L as LoadingUtil, bJ as BeaconService, bK as RTS_Service, bL as IconUtil, v as ViewContext } from "./yes-core-636cc260.js";
import { M as MainFrame } from "./index-4bc641ea.js";
import "./vendor-e1ca6068.js";
MainFrameInterface.MainFrame = MainFrame;
LLMChatInterface.LLMChat = LLMChat;
LLMChatInterface.LLMChatTrigger = LLMChatTrigger;
window.addEventListener("error", function(e) {
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  ExceptionStack.push(e.reason);
});
window.addEventListener("YIUI-loaded", function() {
  StatusProxy.licenseCheck();
});
window.Yes_TEMP_LoggedInState = true;
window.addEventListener("beforeunload", (e) => {
  console.log("main onbeforeunload");
  if (window.Yes_TEMP_LoggedInState) {
    e.preventDefault();
    e.returnValue = "";
    return "";
  }
});
async function init() {
  let strings = await SvrMgr.loadi18nData();
  I18N.seti18nStrings(strings);
  const mainContainer = MainContainerBuilder(Tabs);
  MainContainer.set(mainContainer);
  SvrMgr.getSessionInfo().then(function(result) {
    if (result) {
      if (result.SessionParas) {
        var sessionData = result.SessionParas;
        if (typeof sessionData === "string") {
          sessionData = JSON.parse(sessionData);
        }
        SessionParasCache.setParas(sessionData);
      }
      SessionInfo.setCode(result.Code);
      SessionInfo.setUserName(result.Name);
      SessionInfo.setUserID(result.UserID);
      SessionInfo.setClusterID(result.clusterID);
      SessionInfo.setLoginTime(result.Time);
    } else {
      SessionInfo.clear();
    }
  });
  await IconSourceLoader.loadIconSourceFile();
  window.YIUI = {
    ...window.YIUI || {},
    YesCore,
    YesBaseComponent: YesVBaseComponent,
    BuilderMap: ControlMapping,
    treeClickHandle: treeClickHandle(mainContainer),
    SvrMgr,
    SessionInfo,
    I18N,
    ControlType,
    CookiesUtil,
    errorHandle(e) {
      return ExceptionStack.push(e);
    },
    FormBuilder,
    MetaService,
    FormTarget,
    OperationState,
    NewOpt,
    OptQueue,
    FormRenderUtil,
    RemoteService,
    YesOwnerDraw,
    FormStack,
    BaseDialog,
    YElement,
    h,
    isShowReloadButton: true,
    // 是否显示reload按钮
    // reg: function(){}
    GridSetting,
    AppSetting,
    FormType,
    APP: {
      MainFrame
    },
    NotificationMgr,
    MenuFavoriteService,
    ViewParser,
    Expr: FuncMap,
    DataService,
    DictService,
    LoadingUtil,
    BeaconService,
    RTS_Service,
    IconUtil
  };
  window.YIUI.webRoot = (() => {
    let url;
    if (SvrMgr.baseurl) {
      url = `${SvrMgr.baseurl}/${"yesui"}/`;
    } else {
      url = `${"yesui"}/`;
    }
    return url;
  })();
  AppSetting.updateClientSetting("mainframe.openEntryByClick", true);
  AppSetting.updateClientSetting("mainframe.closeOtherEntry", false);
  window.View = {
    FuncMap: null
  };
  window.Expr = {
    regCluster: function(map, funext) {
      YesCore.Functions.regCluster(funext);
    }
  };
  window.exec = async function(formID, formula) {
    var form = FormStack.getForm(formID);
    var cxt = new ViewContext(form);
    if (form) {
      return form.eval(formula, cxt);
    } else {
      var parser = new ViewParser();
      return parser.eval(formula, cxt);
    }
  };
}
init().then(async () => {
  afterYIUILoad();
  await UIOptTraceUtil.init();
  window.YIUI.MainUIOptTracer = MainUIOptTracer;
  function repeatUploadUserTraces() {
    UIOptTraceUtil.uploadTraces();
    setTimeout(repeatUploadUserTraces, 3e5);
  }
  repeatUploadUserTraces();
});
FormRender.setYesCom(new YesModalContainer());
new Tabs({
  parent: document.querySelector("#app")
});
let LLMChatFlag = false;
AppSetting.registerClientSettingsListener("yescore.llmchat.enable", (key, value) => {
  if (value) {
    LLMChatTrigger.init();
    LLMChatFlag = true;
  } else {
    if (LLMChatFlag) {
      LLMChatTrigger.destroy();
      LLMChatFlag = false;
    }
  }
});
//# sourceMappingURL=main-30dcdde0.js.map
