import "./modulepreload-polyfill-7faf532e.js";
import { c as YElement, A as YesModalContainer, M as MainContainerBuilder } from "./yes-ui-c6bba9c4.js";
import { r as regH5Controls, T as Tabs } from "./yes-ui-m-f715f53a.js";
import { a as MLogin, E as ErrorUtils, T as TabContainerExprHandler, d as TabContainerUIProcess, e as TabContainerBuilder, m as mobilefun } from "./yes-core-m-4aa7a5fa.js";
import { e as FallBackUtil, q as ExceptionStack, am as Request, bD as YesCore, I as InterActiveFactory, X as CompSetting, S as SvrMgr, bE as CookiesUtil, bA as AppSetting, bM as ErrorUtil, bN as ExprHandlerMap, w as ControlType, bO as CalcMap, d as CompBuilder, F as FocusFactory, bP as FocusPolicy, l as FuncMap, bC as SessionParasCache, bt as SessionInfo, bF as RemoteService, bu as Env, M as MetaService, f as MetaForm, g as FormFactory, h as FormType, O as OperationState, i as OptQueue, N as NewOpt, j as FormBuilder, v as ViewContext, bx as afterYIUILoad, bz as FormRender, k as FormStack } from "./yes-core-636cc260.js";
import "./vendor-e1ca6068.js";
window["doFormGoBackEvent"] = function() {
  let isBackApp = FallBackUtil.isBackApp();
  if (isBackApp) {
    FallBackUtil.doFallBack();
  }
  return isBackApp;
};
window.addEventListener("error", function(e) {
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  ExceptionStack.push(e.reason);
});
const MainContainer = MainContainerBuilder(Tabs);
Request.mode = 2;
window.YIUI = {
  ...window.YIUI || {},
  YesCore,
  confirmPanelSize: "70% auto",
  InterActiveFactory,
  MLogin,
  YElement,
  supportTouch: "ontouchstart" in window,
  MainContainer,
  CompSetting,
  SvrMgr,
  CookiesUtil,
  AppSetting,
  ErrorUtil
};
ErrorUtils.LoginInfo();
ExprHandlerMap.reg(ControlType.CONTAINER, TabContainerExprHandler);
CalcMap.reg(ControlType.CONTAINER, TabContainerUIProcess);
CompBuilder.reg(ControlType.CONTAINER, new TabContainerBuilder());
FocusFactory.setFocuspolicy(FocusPolicy);
FuncMap.regCluster(mobilefun);
SvrMgr.getSessionInfo().then(function(result) {
  if (result) {
    if (result.SessionParas) {
      var sessionData = result.SessionParas;
      if (typeof sessionData === "string") {
        sessionData = JSON.parse(sessionData);
      }
      SessionParasCache.setParas(sessionData);
    }
    SessionInfo.setCode(result.Code);
    SessionInfo.setUserName(result.Name);
    SessionInfo.setUserID(result.UserID);
    SessionInfo.setClusterID(result.clusterID);
    SessionInfo.setLoginTime(result.Time);
  } else {
    SessionInfo.clear();
  }
}).finally(async () => {
  await new RemoteService().getMobileEnvDef().then(function(mobileInfo) {
    let { MetaFormAliasKeys, MetaMobileDef } = mobileInfo;
    Env.setAliasKeyMap(MetaFormAliasKeys);
    if (MetaMobileDef && MetaMobileDef["eventDefCollection"]) {
      Env.setEventDefCollection(MetaMobileDef["eventDefCollection"]);
    }
  }).catch(function(e) {
    throw e;
  });
  await SvrMgr.checkSession().then(function(result) {
    if (result) {
      startForm();
    } else {
      SvrMgr.touristLogin().then(() => {
        startForm();
      });
    }
  });
});
let startForm = function() {
  SvrMgr.getStartForm().then((res) => {
    if (!res) {
      throw Error("未定义启动项，请配置中定义后重试");
    }
    let { startForm: startForm2, loginForm } = res;
    MLogin.setLoginForm(loginForm, startForm2);
    let metaService = new MetaService();
    return metaService.getMetaForm(startForm2).then((meta) => {
      var metaForm = new MetaForm(meta);
      let appEnv = null;
      var emptyForm = FormFactory.create(metaForm, appEnv);
      if ((emptyForm["type"] == FormType.ENTITY || emptyForm["type"] == FormType.DICT) && emptyForm["metaForm"].initState == OperationState.NEW) {
        emptyForm.setOptQueue(new OptQueue(new NewOpt(emptyForm)));
      }
      return emptyForm.calcCaption().then(function() {
        var builder = new FormBuilder(metaForm.key);
        builder.setContainer(MainContainer);
        return builder.build(emptyForm);
      });
    });
  }).finally(async () => {
    await doAddressLink();
    startForm = null;
    doAddressLink = null;
    displayByShareForm = null;
  });
};
let doAddressLink = function() {
  var query = window.location.search.substring(1);
  if (query) {
    var callurl = "", callArr = [], paraJson = {};
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
      var pair = vars[i].split("=");
      if (pair[0] == "link") {
        callurl = pair[1] + "?";
      } else {
        callArr.push(vars[i]);
        paraJson[pair[0]] = pair[1];
      }
    }
    callurl = callurl + callArr.join("&");
    if (paraJson["formKey"]) {
      displayByShareForm(JSON.stringify(paraJson));
    }
  }
};
let displayByShareForm = function(paraJson) {
  var paras = JSON.parse(paraJson);
  var formList = FormStack.getFormList();
  if (!formList)
    return;
  var form = formList[formList.length - 1];
  var cxt = new ViewContext(form);
  var formula = "Show('" + paras.formKey + "')";
  if (paras.oid > 0) {
    formula = "Open('" + paras.formKey + "'," + paras.oid + ")";
  }
  return form.asyncEval(formula, cxt);
};
regH5Controls();
afterYIUILoad();
FormRender.setYesCom(new YesModalContainer());
MLogin.setContainer(MainContainer);
new Tabs({
  parent: document.querySelector("#app")
});
//# sourceMappingURL=m_home-fb62a2e7.js.map
