(async function () {
    const { default : elmUtils } =  await import("../../ux/util/elmUtils.js");
    const { loadcss, normalizeUxImageUrl } =  await import("../../ux/util/util.js");

    let el, avaliableNavActions;
    function Navigation(container) {
        this._init(container);
    }

    Navigation.prototype = {
        constructor: Navigation,
        _init: function (container) {
            el = container;
            avaliableNavActions = getAvaliableNavActions();
            formatNavOpt();
            createHTML();
            install();
        },
        reload :function(){
            this._init();
        },
        resize: function () {
            let width = el.offsetWidth;
            let w =
                el.querySelector(".nav-left").offsetWidth +
                el.querySelector(".logo").offsetWidth +
                el.querySelector(".logo-text").offsetWidth +
                el.querySelector(".nav-field-box.user").offsetWidth +
                el.querySelector(".nav-field-box.setting").offsetWidth +
                el.querySelector(".login_username").offsetWidth +
                30;
            el.querySelector(".org_lbl").style.maxWidth = width - w + "px";
        },
        toggle: function () {
            var logo = document.querySelector(".logo"),
                box = document.querySelector(".app-box");

            document.querySelector(".nav-left").classList.toggle("nav-left-sm");
            document
                .querySelector(".menutoggle")
                .classList.toggle("menutoggle-sm");
            logo.classList.toggle("logo-sm");
            const hiddenAppBox = "true" == box.getAttribute('hidden-appbox');
            if (hiddenAppBox) {
                return;
            }
            if (logo.classList.contains("logo-sm")) {
                box.style.display = "none";
            } else {
                box.style.display = "block";
            }
        }
    };

    //FIXME individuation临时添加
    let navigationOption = {
        userActions: ["modifyPwd", "logout", "exit"],
        settingActions: ["about"],
    };

    let getAvaliableNavActions = () => [
        {
            name: "logout",
            caption: "注销",
            actionType: "Buildin",
            buildinCommand: "logout",
            icon: "/F21A",
        },
        {
            name: "exit",
            caption: "退出",
            actionType: "Buildin",
            buildinCommand: "exit",
            icon: "/F379",
        },
        {
            name: "modifyPwd",
            caption: "修改密码",
            actionType: "Buildin",
            buildinCommand: "modifyPwd",
            icon: "/F20A",
        },
        {
            name: "about",
            caption: "系统信息",
            actionType: "Buildin",
            buildinCommand: "about",
            icon: "/F18C",
        },
    ];

    function formatNavOpt() {
        if (!window.YigoClassicUxSetting) {
            return;
        }
        navigationOption =
            YigoClassicUxSetting.navigationOption || navigationOption;
        avaliableNavActions =
            YigoClassicUxSetting.avaliableNavActions || avaliableNavActions;
        //过滤
        let actionNameList = avaliableNavActions.map((item) => item.name);
        for (let key in navigationOption) {
            navigationOption[key] = navigationOption[key].filter((v) => {
                if (v == "-") return true;
                return actionNameList.includes(v);
            });
            removeRepeatLine(navigationOption[key]);
        }

        function removeRepeatLine(arr) {
            for (let i = 0; i < arr.length; i++) {
                if (arr[i] == "-" && arr[i + 1] && arr[i] == arr[i + 1]) {
                    arr.splice(i, 1);
                    i--;
                }
            }
            //去头尾
            if (arr[0] == "-") {
                arr.shift();
            }
            if (arr[arr.length - 1] == "-") {
                arr.pop();
            }
        }
    }

    function createHTML() {
        createApp();
        createRightSection();
        createInstanceTag();
    }

    function createRightSection() {
        const oUsername = createNode("span", "login_username");
        const user_name = YIUI.SessionInfo.getUserName();
        new YIUI.DictService().getCaption("Operator", YIUI.SessionInfo.getUserID()).then((caption) => {
            let userCode = caption ? caption.split(" ")[0] : null;
            oUsername.innerText = user_name || userCode || YIUI.I18N.getString("NAVIGATION_USERNAME", "Unknown");
        });

        YIUI.APP.MainFrame.appendDomToRightNav(oUsername);
        createFieldSection("setting", navigationOption.settingActions);
        createFieldSection("user", navigationOption.userActions);
    }

    function createFieldSection(name, actions) {
        let oBox;
        if(name == "setting"){
            oBox = createNode("div", "nav-field-box setting");
        }else{
            oBox = createNode("div", "nav-field-box user");
        }
        YIUI.APP.MainFrame.appendDomToRightNav(oBox);
        oBox.innerHTML = "";
        const oBtn = createNode("div", "nav-field-btn");
        const oContent = createNode("div", "nav-field-content");
        const oUl = createNode("ul", "nav-field-list");
        actions.forEach((name) => {
            if (name == "-") {
                createSeparateLink(oUl);
            } else {
                const action = getAvaliableNavActionByName(name);
                if (! action){
                    throw new Error("Invalid NavAction: " + name);
                }
                createActionItem(oUl, action);
            }
        });
        oContent.appendChild(oUl);
        oBox.appendChild(oBtn);
        oBox.appendChild(oContent);
    }

    function createSeparateLink(container) {
        const oLink = createNode("li", "nav-field-separateLink");
        container.append(oLink);
    }

    function createActionItem(container, action) {
        const oLi = createNode("li", "nav-field-items");
        const oA = createNode("a", action.name);
        const oSpan = createNode("span");
        oA.innerText = YIUI.I18N.getString(`NAVACTION_${action.name.toUpperCase()}`, action.caption); // NAVACTION_LOGOUT,NAVACTION_EXIT,NAVACTION_MODIFYPWD等
        setItemIcon(oSpan, action.name);
        oA.insertBefore(oSpan, oA.firstChild);
        oLi.appendChild(oA);
        container.append(oLi);
        oA.addEventListener("click", actionItemclickHandler.bind(oA, action));
    }

    function setItemIcon(elm, name) {
        const action = getAvaliableNavActionByName(name);
        var icon = action && action.icon;
        //elm.innerHTML = '&#xE67A'
        if (!icon) return;
        if (icon.indexOf("url(") == 0) {
            elm.style.backgroundImage = icon;
        }
        if (icon.indexOf("/") == 0) {
            elm.innerHTML = icon.replace("/", "&#x");
        }
    }

    function actionItemclickHandler(action) {
        console.log("您点击了", action.caption, action);
        const buildinCommand = action.buildinCommand;
        if (action.buildinCommand) {
            buildinHandler[buildinCommand] && buildinHandler[buildinCommand]();
        } else if (action.actionType === "Dialog" && action.form && action.form.formKey) {
            YIUI.APP.MainFrame.openFormInDialog(action.form.formKey); // formKey | OID | options
        }
        this.closest(".nav-field-content").style.display = "none";
    }

    function createInstanceTag() { // 右上角的当前系统性质，比如开发版DEV
        // Get setting
        let setting = window.YigoClassicUxSetting 
                        && YigoClassicUxSetting.mainFrameDecoration 
                        && YigoClassicUxSetting.mainFrameDecoration.instanceTagImageUrl;
        if (!setting) { // invalid setting
            return;
        }

        loadcss(window.Yes_ENV_WebRoot + "ux/instance-tag.css");    

        // create
        let getDefaultTagName = function(name) {
            let tags = ['DEV', 'GRP', 'ITS', 'PRD', 'PRE', 'QAS', 'RTS', 'SDB', 'TRN', 'UAT'];

            for (let i=0; i<tags.length; i++) {
                if (name.trim().toUpperCase() == tags[i]) {
                    return tags[i];
                }
            }
        };
        let createDefaultTag = function(name) {
            // create
            const tag = createNode('div', 'instance-tag default-tag ' + name);
            tag.innerText = name;

            return tag;
        };

        let createCustomizedTag = function(setting) {
            // create
            const tag = createNode('div', 'instance-tag custom-tag');
            document.documentElement.style.setProperty('--yigoInstanceTagBackgroundImageUrl', normalizeUxImageUrl(setting, true));
            return tag;
        };

        let name = getDefaultTagName(setting);
        let tag;
        if (name) {
            tag = createDefaultTag(name);
        } else {
            tag = createCustomizedTag(setting);
        }

        // append
        YIUI.APP.MainFrame.setInstanceTag(tag);
    }

    function install() {
        fieldBtnClickHandler();
        appBoxInstall();
    }

    function fieldBtnClickHandler() {
        const oFieldBtn = el.querySelectorAll(".nav-field-btn");
        oFieldBtn.forEach((btn) => {
            btn.addEventListener("click", function (e) {
                clickHandler.call(this);
                e.stopPropagation();
            });
        });
        const oFieldBox = el.querySelectorAll(".nav-field-box");
        oFieldBox.forEach((box) => {
            box.addEventListener("mouseleave", function () {
                this.querySelector(".nav-field-content").style.display = "none";
            });
            box.addEventListener("mousedown", (e) => e.stopPropagation());
        });
        function clickHandler() {
            var oContent = this.nextElementSibling;
            let isShow = getComputedStyle(oContent).display != "none";
            let isSetting = this.closest(".setting") != null;
            let isUser = this.closest(".user") != null;
            window.YIUI.MainUIOptTracer.getInstance().traceOnNavigationClick({ isSetting, isUser });
            if (isShow) {
                oContent.style.display = "none";
            } else {
                hideAllContent();
                elmUtils.slideDown(oContent);
                elmUtils.onceEventHandler(document, "mousedown", () => {
                    oContent.style.display = "none";
                });
            }
        }

        function hideAllContent() {
            oFieldBtn.forEach((btn) => {
                btn.nextElementSibling.style.display = "none";
            });
        }
    }

    function appBoxInstall() {
        const oBtn = el.querySelector(".app-box-btn");
        oBtn.addEventListener("click", function (e) {
            const oContent = this.nextElementSibling;
            let isShow = getComputedStyle(oContent).display != "none";
            if (isShow) {
                oContent.style.display = "none";
            } else {
                elmUtils.slideDown(oContent);
                elmUtils.onceEventHandler(document, "mousedown", () => {
                    oContent.style.display = "none";
                });
            }
            e.stopPropagation();
        });
        oBtn.addEventListener("mousedown", (e) => e.stopPropagation());

        el.querySelectorAll(".appItems ul li a").forEach((item) => {
            item.addEventListener("click", itemClickHandler.bind(item));
        });

        function itemClickHandler(e) {
            let key = this.getAttribute("id");
            YIUI.CookiesUtil.set("infokey", key);
            el.querySelector(".appItems").style.display = "none";
            e.stopPropagation();
        }
    }

    const buildinHandler = {
        about,
        logout,
        exit,
        modifyPwd,
        userProfile
    };

    function userProfile() {
        var clientParameters = window.YigoClassicUxSetting && window.YigoClassicUxSetting.clientParameters;
        var individualityFormKey = clientParameters && clientParameters.individualityFormKey;
        var formKey = individualityFormKey || 'V_UX_DefaultIndividuality';
        YIUI.APP.MainFrame.openFormInRightSlide(formKey); // formKey | OID | options | sizeOptions
    }

    function modifyPwd() {
        YIUI.MainUIOptTracer.getInstance().traceOnNavigationClick({ isModifyPwd: true});
        const formKey = "ChangePassWord";
        YIUI.APP.MainFrame.openFormInDialog(formKey); // formKey | OID | options
    }

    let can_logout = true;
    let channel = BroadcastChannel ? new BroadcastChannel('Yigo-Channel') : null;
    if( channel ) {
        channel.onmessage = e => {
            if( e.data == "pong" ) {
                can_logout = false;
            } else if ( e.data == 'ping' ) {
                channel.postMessage("pong");
            }
        }
     }

    async function logout() {
        YIUI.MainUIOptTracer.getInstance().traceOnNavigationClick({ isLogout: true});
        await YIUI.MainUIOptTracer.getInstance().syncUploadTraces();
        if( channel ) {
            channel.postMessage("ping");
            setTimeout(() => {
                if( can_logout ) {
                    YIUI.SvrMgr.doLogout().finally(function () {
                        channel?.close();
                        YIUI.CookiesUtil.remove("clientID");
                        YIUI.CookiesUtil.remove("oldURL");

                        // FIXME 后续应受 MainFrame 状态的统一管理
                        window.Yes_TEMP_LoggedInState = false;

                        window.location.reload();
                    });
                } else {
                    can_logout = true; // 重置
                    const dialog = new YIUI.BaseDialog({
                        headerTitle: YIUI.I18N.getString("DIALOG_TIPS", "提示"),
                        resizeit:{  disable: true },
                        panelSize:"300 200",
                        content: YIUI.I18N.getString("NAVIGATION_OTHER_TAB_LOGIN",`有其他客户端登录,请先退出其他客户端`),
                    });
                    dialog.addClassName("panel","modal");
                    dialog.show();
                }
            },100);
        } else {
            YIUI.SvrMgr.doLogout().finally(function () {
                YIUI.CookiesUtil.remove("clientID");
                YIUI.CookiesUtil.remove("oldURL");

                // FIXME 后续应受 MainFrame 状态的统一管理
                window.Yes_TEMP_LoggedInState = false;

                window.location.reload();
            });
        }
    }

    async function exit() {
        YIUI.MainUIOptTracer.getInstance().traceOnNavigationClick({ isExit: true});
        await YIUI.MainUIOptTracer.getInstance().syncUploadTraces();
        YIUI.SvrMgr.doLogout().finally(function () {
            channel?.close();
            YIUI.CookiesUtil.remove("clientID");
            YIUI.CookiesUtil.remove("oldURL");

            // FIXME 后续应受 MainFrame 状态的统一管理
            window.Yes_TEMP_LoggedInState = false;

            window.location.replace("about:blank");
        });
    }
    /**
     * 系统配置内部处理
     */
    async function about() {
        window.YIUI.MainUIOptTracer.getInstance().traceOnNavigationClick({ isAbout: true });
        // 通过ux配置获取系统配置的formkey
        const formKey = YIUI.AppSetting.getClientSetting("mainframe.aboutFormKey");
        if (formKey) {
            // 获取系统配置弹框是否显示头标题,默认不显示弹框头
            const aboutDialogShowHeader = YIUI.AppSetting.getClientSetting("mainframe.aboutDialogShowHeader") || false;
            try {
                await YIUI.APP.MainFrame.openFormInDialog(formKey, -1, { modalHeaderShow:aboutDialogShowHeader }); // formKey | OID | options
            } catch (error) {
                console.error(`error:${error}。您配置的系统信息表单${formKey}错误，请检查`);
                YIUI.LoadingUtil.hide();
                aboutDefault();
            }
        } else {
            aboutDefault();
        }
    }
    // 默认系统配置
    async function aboutDefault() {
        // 配置系统弹框报错，需要单独对系统信息处理，显示默认
        try {
            const formKey = "SystemInformation";
            // 调用默认系统信息
            await YIUI.APP.MainFrame.openFormInDialog(formKey, -1, { modalHeaderShow: false }); // formKey | OID | options
        } catch (error) {
            console.error(`error:${error}。默认系统信息错误，请联系相关人员检查`);
            YIUI.LoadingUtil.hide();
            // 默认配置报错，走固定渲染
            aboutBuildin();
        }
    }
    // 默认固定系统信息渲染
    async function aboutBuildin() {
        var aboutInfo = await Promise.all([
            YIUI.SvrMgr.getLicenseInfo(),
            YIUI.SvrMgr.getSystemInfo(),
            YIUI.SvrMgr.getProjectSystemInfo(),
        ]);

        let { licenseTo, moduleInfo } = aboutInfo[0];

        moduleInfo = formatInfo(moduleInfo);
                console.log(YIUI.I18N.getString("NAVIGATION_APPVER","版本："), aboutInfo[1].Ver);
                console.log(YIUI.I18N.getString("NAVIGATION_APPBUILDID","创建号："), aboutInfo[1].BuildID);

                let sectionStr = `
                    <p>${YIUI.I18N.getString("NAVIGATION_YIGOVER","平台版本")}:  ${aboutInfo[1].Ver}</p>
                    <p>${YIUI.I18N.getString("NAVIGATION_APPBUILDID","创建号")}:  ${aboutInfo[1].BuildID}</p>
                `;
                if (window.Yes_ENV_BrandName === 'ERP') {
                    const ver = aboutInfo[2].Ver || 'ERP-SNAPSHOT';
                    const buildID = aboutInfo[2].BuildID || '20231231';
                    sectionStr = `
                        <p>${YIUI.I18N.getString("NAVIGATION_ERPVER",`ERP版本`)}: ${ver}</p>
                        ${sectionStr}
                        <p>${YIUI.I18N.getString("NAVIGATION_ERPVERDATE","产品发布日期")}: ${buildID}</p>
                    `
                };

                let index = licenseTo ? licenseTo.indexOf(" ") : -1;
                let licenseOrg = index < 0 ? licenseTo : licenseTo.slice(0, index).trim();
                let licenseTime = index < 0 ? "" : licenseTo.slice(index).trim();
                const about_html = `<div class='sys-about-table'>
                <p class="sys-about-title">${YIUI.I18N.getString(
                    `NAVIGATION_${window.Yes_ENV_BrandName}ABOUT`,
                    `关于${window.Yes_ENV_BrandName}`)}</p>
                <p class="sys-about-copyright">${YIUI.I18N.getString(
                    "NAVIGATION_APPCOPYRIGHTS",
                    "上海博科资讯股份有限公司"
                )}</p>
                <p class="license">${licenseOrg}</p>
                <p>${licenseTime}</p>
                ${sectionStr}
                </div>`;
                const dialog = new YIUI.BaseDialog({
                    header:false,
                    maskClick:true,
                    resizeit:{  disable: true },
                    panelSize:"720 420",
                    content: about_html,
                });

                dialog.addClassName("panel", `sys-about ${window.Yes_ENV_BrandName}`);

        dialog.show();
        var _btn = document.querySelector(".sys-about-footer button");
        _btn && _btn.addEventListener("click", () => {
            dialog.close();
            _btn = null;
        });

        function formatInfo(info) {
            var result = {};
            info.split(";").forEach((item) => {
                var arr = item.split(":");
                result[arr[0]] = arr[1];
            });
            return result;
        }
    }

    function createApp() {
        let appBox = createNode("div","app-box");
        let btn = createNode("div","app-box-btn");
        let items = createNode("div","appItems");
        let ul = createNode("ul");
        items.appendChild(ul);
        appBox.appendChild(btn);
        appBox.appendChild(items);

        YIUI.APP.MainFrame.appendDomToLeftNav(appBox, "before"); // position: before | after, 默认 after

        let metaService = new YIUI.MetaService();
        metaService.getAppList().then(function (ret) {
            const needBox = ret.servers && ret.servers.length > 0;
            appBox.setAttribute('hidden-appbox', !needBox);
            if (needBox) {
                ret.servers.forEach(function (server) {
                    const oLi = createNode("li");
                    const oA = createNode("a");
                    oA.innerHTML = server.caption || "test";
                    oA.setAttribute("id", server.key);
                    if (server.url.indexOf("?") != -1) {
                        _a.setAttribute(
                            "href",
                            server.url + "&appkey=" + server.key
                        );
                    } else {
                        _a.setAttribute(
                            "href",
                            server.url + "?appkey=" + server.key
                        );
                    }
                    oLi.appendChild(oA);
                    container.appendChild(oLi);
                    el.querySelector(".app-box").style.display = "block";
                });
                appBox.style.display = "block";
            } else {
                appBox.style.display = "none";
            }
        });
    }

    function getAvaliableNavActionByName(name) {
        return avaliableNavActions.filter((item) => item.name == name)[0];
    }

    function createNode(tragetName, classname) {
        let node = document.createElement(tragetName);
        if (classname) {
            let arr = classname.split(" ");
            arr.forEach((name) => {
                node.classList.add(name);
            });
        }

        return node;
    }
    window.addEventListener("YIUI-loaded", e => {
        new Navigation(document.querySelector('.nav'));
    });

    window.addEventListener("YES-MainFrame-addUserAction", e => {
        createActionItem(el.querySelector(".user .nav-field-list"), e.detail.navAction);
    }, false);
    window.addEventListener("YES-MainFrame-addSettingAction", e => {
        createActionItem(el.querySelector(".setting .nav-field-list"), e.detail.navAction);
    }, false);
})();
