/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.servlet;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.base.SecuritySetting;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.server.ServiceRequest;
import com.bokesoft.yes.mid.server.ServiceResponse;
import com.bokesoft.yes.mid.server.dispatcher.ServiceDispatcherFactory;
import com.bokesoft.yes.mid.session.SessionTicketidRecorder;
import com.bokesoft.yes.mid.web.tool.RequestUtil;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.ServiceContextHolder;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.init.YigoAppState;
import com.bokesoft.yigo.mid.server.IServiceRequest;
import com.bokesoft.yigo.mid.server.IServiceResponse;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class ServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block9: {
            PrintWriter printWriter;
            block8: {
                printWriter = null;
                long l = System.nanoTime();
                try {
                    YigoAppState.checkState();
                    object.setCharacterEncoding("UTF-8");
                    httpServletResponse.setCharacterEncoding("UTF-8");
                    object = this.processService((HttpServletRequest)object, httpServletResponse);
                    if (object == null) break block8;
                    httpServletResponse.setContentType("text/plain;charset=UTF-8");
                    this.modifyHeaders(httpServletResponse);
                    this.recodeProcessTime(httpServletResponse, l);
                    printWriter = httpServletResponse.getWriter();
                    printWriter.write(object.toString());
                }
                catch (Throwable throwable) {
                    try {
                        TraceSystemManager.setEnforceError();
                        JSONObject jSONObject = new JSONObject();
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject.put("error", (Object)jSONObject2);
                        jSONObject.put("success", false);
                        if (throwable instanceof CoreException) {
                            CoreException coreException = (CoreException)throwable;
                            jSONObject2.put("error_code", coreException.getCode());
                            jSONObject2.put("error_info", (Object)coreException.getMessage());
                        } else {
                            jSONObject2.put("error_code", -1);
                            jSONObject2.put("error_info", (Object)(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()));
                        }
                        httpServletResponse.setContentType("application/json;charset=UTF-8");
                        this.modifyHeaders(httpServletResponse);
                        this.recodeProcessTime(httpServletResponse, l);
                        httpServletResponse.getWriter().write(jSONObject.toString());
                        return;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        ServiceContextHolder.clearRequest();
                        ServiceContextHolder.clearResponse();
                        if (printWriter == null) break block9;
                        printWriter.close();
                    }
                }
            }
            ServiceContextHolder.clearRequest();
            ServiceContextHolder.clearResponse();
            if (printWriter != null) {
                printWriter.close();
                return;
            }
        }
    }

    protected void modifyHeaders(HttpServletResponse httpServletResponse) {
        Map map = SecuritySetting.getInstance().getResponseHead();
        if (map == null || map.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                httpServletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            return;
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("mid", throwable);
            return;
        }
    }

    protected void recodeProcessTime(HttpServletResponse httpServletResponse, long l) {
        long l2 = (System.nanoTime() - l) / 1000000L;
        try {
            httpServletResponse.addHeader("X-Response-Time", Long.toString(l2));
            return;
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("mid", throwable);
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected IServiceResponse createResponse() throws Throwable {
        return new ServiceResponse();
    }

    protected void preparedRequest(ServiceRequest serviceRequest, HttpServletRequest httpServletRequest, HttpServletResponse object) throws Throwable {
        Object object2;
        int n;
        Object object3;
        Object object4;
        object = httpServletRequest.getCookies();
        if (object != null) {
            object4 = Boolean.FALSE;
            object3 = Boolean.FALSE;
            int n2 = ((Cookie[])object).length;
            for (n = 0; !(n >= n2 || ((Boolean)object4).booleanValue() && ((Boolean)object3).booleanValue()); ++n) {
                object2 = object[n];
                if (object2.getName().equalsIgnoreCase("clientID")) {
                    serviceRequest.setClientID(object2.getValue());
                    object4 = Boolean.TRUE;
                    continue;
                }
                if (!object2.getName().equals("locale")) continue;
                int n3 = object2.getValue().indexOf(45);
                serviceRequest.setLanguage(object2.getValue().substring(0, n3));
                serviceRequest.setLocale(object2.getValue());
                object3 = Boolean.TRUE;
            }
        }
        if ((object4 = httpServletRequest.getParameter("yigoData")) != null && !((String)object4).isEmpty()) {
            object3 = Base64.decode((byte[])((String)object4).getBytes());
            String string = GZIPTools.decompress((InputStream)new ByteArrayInputStream((byte[])object3), (String)"UTF-8");
            object2 = new JSONObject(string);
            object3 = object2.keySet().iterator();
            while (object3.hasNext()) {
                object = object3.next().toString();
                if (object2.isNull((String)object)) {
                    serviceRequest.putParameter((String)object, null);
                    continue;
                }
                object4 = TypeConvertor.toString((Object)object2.get((String)object));
                serviceRequest.putParameter((String)object, object4);
                if (((String)object).equals("mode")) {
                    serviceRequest.setMode(TypeConvertor.toInteger((Object)object4).intValue());
                    continue;
                }
                if (((String)object).equals("language")) {
                    serviceRequest.setLanguage((String)object4);
                    continue;
                }
                if (((String)object).equals("locale")) {
                    serviceRequest.setLocale((String)object4);
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("path")) continue;
                serviceRequest.putParameter((String)object, (Object)URLDecoder.decode((String)object4, "UTF-8"));
            }
        }
        object3 = httpServletRequest.getParameterMap().keySet().toArray();
        for (n = 0; n < ((Object[])object3).length; ++n) {
            String string = object3[n].toString();
            if (string.equals("yigoData")) continue;
            object2 = httpServletRequest.getParameter(string);
            serviceRequest.putParameter(string, object2);
            if (string.equals("mode")) {
                serviceRequest.setMode(TypeConvertor.toInteger((Object)object2).intValue());
                continue;
            }
            if (string.equals("language")) {
                serviceRequest.setLanguage((String)object2);
                continue;
            }
            if (string.equals("locale")) {
                serviceRequest.setLocale((String)object2);
                continue;
            }
            if (!string.equalsIgnoreCase("path")) continue;
            serviceRequest.putParameter(string, (Object)URLDecoder.decode((String)object2, "UTF-8"));
        }
        String string = RequestUtil.getIPAddr((HttpServletRequest)httpServletRequest);
        serviceRequest.setIP(string);
        String string2 = String.valueOf(RequestUtil.getPort((HttpServletRequest)httpServletRequest));
        serviceRequest.setPort(string2);
        object2 = RequestUtil.getHost((HttpServletRequest)httpServletRequest);
        serviceRequest.setHost((String)object2);
        object3 = httpServletRequest.getContextPath();
        object = ((String)object3).startsWith("/") ? ((String)object3).substring(1) : (((String)object3).isEmpty() ? "yigo" : object3);
        serviceRequest.setContextName((String)object);
        object = httpServletRequest.getHeader("range");
        serviceRequest.putParameter("range", object);
    }

    protected IServiceRequest createRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        ServiceRequest serviceRequest = new ServiceRequest();
        this.preparedRequest(serviceRequest, httpServletRequest, httpServletResponse);
        String string = serviceRequest.getClientID();
        if (string == null || string.isEmpty()) {
            string = UUID.randomUUID().toString();
            serviceRequest.setClientID(string);
        }
        RequestUtil.addClientID((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)string);
        return serviceRequest;
    }

    public Object processService(HttpServletRequest object, HttpServletResponse httpServletResponse) throws Throwable {
        IServiceRequest iServiceRequest = this.createRequest((HttpServletRequest)object, httpServletResponse);
        this.checkTicketID(iServiceRequest, (HttpServletRequest)object);
        object = ServiceDispatcherFactory.getInstance().create(iServiceRequest);
        IServiceResponse iServiceResponse = this.createResponse();
        ServiceContextHolder.setRequest((IServiceRequest)iServiceRequest);
        ServiceContextHolder.setResponse((IServiceResponse)iServiceResponse);
        TraceRecorder.traceData((String)"ServiceRequest", (Object)iServiceRequest);
        object.processService(iServiceRequest, iServiceResponse);
        object = iServiceResponse.getResult();
        this.dealTicketID(iServiceRequest, httpServletResponse);
        this.createNewClientID(iServiceRequest, httpServletResponse);
        TraceRecorder.traceData((String)"ServiceResponse", (Object)iServiceResponse);
        if (iServiceResponse.hasErr()) {
            throw iServiceResponse.getException();
        }
        return object;
    }

    private void dealTicketID(IServiceRequest iServiceRequest, HttpServletResponse httpServletResponse) {
        String string = iServiceRequest.getClientID();
        int n = iServiceRequest.getMode();
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (serverSetting.containsValidateLevel(2) || serverSetting.containsValidateLevel(6)) {
            n = SessionTicketidRecorder.update((String)string, (int)n);
            httpServletResponse.setHeader("ticketid", String.valueOf(n));
        }
    }

    private void createNewClientID(IServiceRequest iServiceRequest, HttpServletResponse httpServletResponse) {
        long l;
        long l2;
        ISessionInfoProvider iSessionInfoProvider;
        String string = iServiceRequest.getClientID();
        int n = iServiceRequest.getMode();
        Long l3 = ServerSetting.getInstance().getSessionKeepTime();
        if (l3 > 0L && (iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n)) != null && (string = iSessionInfoProvider.getSessionInfoMap().get(string)) != null && string.getType() == 1 && (l2 = new Date().getTime()) - (l = string.getCreateTime().getTime()) >= l3 * 1000L && string != null && string instanceof SessionInfo) {
            l3 = (SessionInfo)string;
            String string2 = UUID.randomUUID().toString();
            l3.setClientID(string2);
            iSessionInfoProvider.getSessionInfoMap().put(string2, (ISessionInfo)string);
            httpServletResponse.setHeader("newClientID", string2);
        }
    }

    private void checkTicketID(IServiceRequest iServiceRequest, HttpServletRequest httpServletRequest) throws Throwable {
        int n;
        int n2;
        if (iServiceRequest == null) {
            return;
        }
        String string = iServiceRequest.getClientID();
        int n3 = iServiceRequest.getMode();
        ServerSetting serverSetting = ServerSetting.getInstance();
        if ((serverSetting.containsValidateLevel(2) || serverSetting.containsValidateLevel(6)) && (n2 = SessionTicketidRecorder.getTicketID((String)string, (int)n3)) != (n = TypeConvertor.toInteger((Object)httpServletRequest.getHeader("ticketid")).intValue())) {
            ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n3);
            if (iSessionInfoProvider != null) {
                iSessionInfoProvider.getSessionInfoMap().remove(string);
            }
            throw new SessionException(12, SessionException.formatMessage(null, (int)12, (Object[])new Object[0]));
        }
    }
}

