/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.webcollections.erpbase;

import com.bokesoft.erp.filter.ProcessErrorFilter;
import com.bokesoft.erp.function.ERPMidFunctionCluster;
import com.bokesoft.erp.para.ParaDefines;
import com.bokesoft.erp.view.CreateViewByXml;
import com.bokesoft.yes.erp.config.ERPMetaFactory;
import com.bokesoft.yes.erp.lock.ERPBusinessLockService;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.cmd.ERPRowExpandService;
import com.bokesoft.yes.mid.cmd.ERPService;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DictionaryService;
import com.bokesoft.yes.mid.cmd.richdocument.strut.OrgDictService;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentService;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichServiceFilterImpl;
import com.bokesoft.yes.mid.module.IModulePlugin;
import com.bokesoft.yes.mid.service.filter.ServiceFilterFactory;
import com.bokesoft.yes.mid.web.services.HeadInfoFieldService;
import com.bokesoft.yes.mid.web.services.OperatorService;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtService;
import com.bokesoft.yigo.meta.enhance.MetaService;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.util.MidFunctionUtil;
import com.bokesoft.yigo.mid.service.IExtService;
import com.bokesoft.yigo.mid.service.IServiceFilter;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.parser.IFunctionProvider;
import com.bokesoft.yigo.tools.wildcard.WildcardUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERPServiceInitiator
implements IModulePlugin {
    private static Logger logger = LoggerFactory.getLogger(ERPServiceInitiator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERPServiceInitiator() {
        DefaultContext context = null;
        try {
            context = ContextBuilder.create();
            logger.info("{} - \u5f00\u59cb\u521d\u59cb\u5316\u8fc7\u7a0b ...", ERPServiceInitiator.class);
            this.init(context);
            logger.info("{} - \u521d\u59cb\u5316\u5b8c\u6210 .", ERPServiceInitiator.class);
            context.commit();
        }
        catch (Throwable ex) {
            logger.error(ERPServiceInitiator.class + " - \u521d\u59cb\u5316\u9519\u8bef: " + ex.getMessage(), ex);
            if (null != context) {
                try {
                    context.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ExceptionUtils.rethrow((Throwable)ex);
        }
        finally {
            if (null != context) {
                try {
                    context.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void init(DefaultContext context) throws Throwable {
        this.initERPMetaFactory(context);
        MidFunctionUtil midFunctionUtil = new MidFunctionUtil();
        midFunctionUtil.regFunctionProvider((IFunctionProvider)new ERPMidFunctionCluster());
        ServiceProviderFactory.registerProvider((Object[][])this.getERPServices());
        ServcieFilterProviderFactory.registerProvider(this.getERPServiceFilters());
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaEnhance enhance = metaFactory.getEnhance(null);
        if (enhance != null) {
            MetaExtService metaExtService = enhance.getMetaExtService();
            if (metaExtService == null) {
                metaExtService = new MetaExtService();
                enhance.setMetaExtService(metaExtService);
            }
            this.addExtService(metaExtService, ERPRowExpandService.class.getSimpleName(), ERPRowExpandService.class);
            this.addExtService(metaExtService, HeadInfoFieldService.class.getSimpleName(), HeadInfoFieldService.class);
        }
        ParaDefines.setParaCheck((boolean)false);
        logger.info("\u5f00\u59cb\u5904\u7406 CreateView.xml ...");
        CreateViewByXml createViewByXml = new CreateViewByXml();
        createViewByXml.invoke(context);
        logger.info("\u5b8c\u6210\u5904\u7406 CreateView.xml .");
    }

    private void initERPMetaFactory(DefaultContext context) {
        IMetaFactory oldMetaFactory = context.getVE().getMetaFactory();
        ERPMetaFactory erpMetaFactory = new ERPMetaFactory(oldMetaFactory);
        MetaFactory.setGlobalInstance((IMetaFactory)erpMetaFactory);
        MidGlobalEnv.getInstance().setMetaFactory((IMetaFactory)erpMetaFactory);
    }

    private <T extends IExtService> void addExtService(MetaExtService metaExtService, String serviceName, Class<T> serviceClass) {
        if (metaExtService.containsKey(serviceName)) {
            return;
        }
        String impl = serviceClass.getName();
        MetaService service = new MetaService();
        service.setName(serviceName);
        service.setImpl(impl);
        metaExtService.add((KeyPairMetaObject)service);
    }

    private Object[][] getERPServices() {
        Object[][] result = new Object[][]{{"RichDocument", new RichDocumentService()}, {"OrgDictService", new OrgDictService()}, {"DictionaryService", new DictionaryService()}, {"ERPBusinessLock", new ERPBusinessLockService()}, {"ERPService", new ERPService()}, {"OperatorService", new OperatorService()}};
        return this.fillExtServices(result);
    }

    private Object[][] fillExtServices(Object[][] services) {
        ArrayList serviceList = new ArrayList(Arrays.asList(services));
        String className = "com.bokesoft.erp.record.cmd.AutoRecordService";
        try {
            Class<?> clazz = Class.forName(className);
            Object inst = clazz.newInstance();
            String serviceName = (String)MethodUtils.invokeMethod(inst, (boolean)true, (String)"getServiceName");
            serviceList.add(new Object[]{serviceName, inst});
        }
        catch (ReflectiveOperationException e) {
            logger.warn("\u5ffd\u7565\u52a0\u8f7d " + className + ", \u539f\u56e0: " + e.getMessage(), (Throwable)e);
        }
        return (Object[][])serviceList.toArray((T[])new Object[0][0]);
    }

    private List<ServiceFilterItem> getERPServiceFilters() {
        return new ArrayList<ServiceFilterItem>(){
            {
                this.add(new ServiceFilterItem("*", ProcessErrorFilter.class));
                this.add(new ServiceFilterItem("RichDocument/*", RichServiceFilterImpl.class));
            }
        };
    }

    private static class ServiceFilterItem {
        private final String name;
        private final Class<? extends IServiceFilter> filterClass;

        public ServiceFilterItem(String name, Class<? extends IServiceFilter> filterClass) {
            this.name = name;
            this.filterClass = filterClass;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends IServiceFilter> getFilterClass() {
            return this.filterClass;
        }
    }

    private static class ServcieFilterProviderFactory {
        private static Map<String, List<Class<? extends IServiceFilter>>> filters = new ConcurrentHashMap<String, List<Class<? extends IServiceFilter>>>();

        private ServcieFilterProviderFactory() {
        }

        public static void registerProvider(List<ServiceFilterItem> items) {
            if (items == null) {
                return;
            }
            for (ServiceFilterItem item : items) {
                String name = item.getName();
                Class<? extends IServiceFilter> filterClass = item.getFilterClass();
                filters.computeIfAbsent(name, key -> new ArrayList()).add(filterClass);
            }
        }

        static {
            ServiceFilterFactory.getInstance().setMatcher((service, arguments) -> {
                Set<Map.Entry<String, List<Class<? extends IServiceFilter>>>> entries = null;
                entries = filters.entrySet();
                ArrayList<IServiceFilter> filters = new ArrayList<IServiceFilter>();
                for (Map.Entry<String, List<Class<? extends IServiceFilter>>> entry : entries) {
                    String key = entry.getKey();
                    if (!WildcardUtil.isMatch((String)service, (String)key)) continue;
                    List<Class<? extends IServiceFilter>> filterClasses = entry.getValue();
                    for (Class<? extends IServiceFilter> filterClass : filterClasses) {
                        filters.add(filterClass.newInstance());
                    }
                }
                return filters;
            });
        }
    }
}

