package com.bokesoft.yigo.mid.web.util;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class DefaultExtensionProvider implements IExtensionProvider{

	@Override
	public MetaForm getExtMetaForm(DefaultContext context, MetaForm sourceForm) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaExtFormList formList = metaFactory.getExtFormList();
		if (formList == null || formList.size() == 0) {
			return null;
		}
		for (int i = 0; i < formList.size(); i++) {
			MetaFormProfile profile = formList.get(i);
			//取第一个
			if (profile.getSourceForm().equals(sourceForm.getKey())) {
				return metaFactory.getExtMetaForm(sourceForm.getKey(), profile.getKey());
			}
		}
		return null;
	}

	@Override
	public IExtensionProvider newInstance() {
		return new DefaultExtensionProvider();
	}

}
