package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.Media;
import com.bokesoft.yigo.common.def.ScreenOrientation;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.MetaComponentView;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaBaseComponentOverrides;
import com.bokesoft.yigo.meta.form.component.view.overrides.OverridesType;
import com.bokesoft.yigo.tools.ve.VE;

public class ViewCollectionJSONBuilder extends AbstractJSONBuilder<MetaViewCollection> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaViewCollection meta) throws Throwable {
		JSONArray metaViewArray = new JSONArray();
		for (int i = 0; i < meta.size(); i++) {
			// 添加MetaView的json
			JSONObject viewObj = new JSONObject();
			MetaView metaView = meta.get(i);
			JSONHelper.writeToJSON(viewObj, JSONConstants.COMMON_KEY, metaView.getKey(), "");
			JSONHelper.writeToJSON(viewObj, JSONConstants.COMMON_CAPTION, metaView.getCaption(), "");
			JSONHelper.writeToJSON(viewObj, JSONConstants.VIEW_MEDIA, Media.toString(metaView.getMedia()), "");
			JSONHelper.writeToJSON(viewObj, JSONConstants.VIEW_SIZE, metaView.getSize(), "");
			JSONHelper.writeToJSON(viewObj, JSONConstants.VIEW_RULE, metaView.getRule(), "");
			JSONHelper.writeToJSON(viewObj, JSONConstants.VIEW_MINWIDTH, metaView.getMinWidth(), 320);
			JSONHelper.writeToJSON(viewObj, JSONConstants.VIEW_SCREENORIENTATION,
					ScreenOrientation.toString(metaView.getScreenOrientation()), ScreenOrientation.str_unspecified);
			
			// MetaView添加MetaComponentView的json
			JSONArray itemArray = new JSONArray();
			Iterator<MetaComponentView> it = metaView.iterator();
			while (it.hasNext()) {
				MetaComponentView metaCompView = it.next();
				JSONObject compViewObj = new JSONObject();
				JSONHelper.writeToJSON(compViewObj, JSONConstants.COMMON_KEY, metaCompView.getKey(), "");

				// MetaComponentView添加MetaBaseComponentOverrides的json
				JSONObject overridesObj = new JSONObject();
				MetaBaseComponentOverrides metaOverrides = metaCompView.getOverrides();
				if(metaOverrides != null){
					JSONHelper.writeToJSON(overridesObj, JSONConstants.COMMON_BACKCOLOR, metaOverrides.getBackColor(), "");
					JSONHelper.writeToJSON(overridesObj, JSONConstants.COMMON_FORECOLOR, metaOverrides.getForeColor(), "");
					JSONHelper.writeToJSON(overridesObj, "fontSize", metaOverrides.getFontSize(), 12);
					JSONHelper.writeToJSON(overridesObj, JSONConstants.COMMON_TYPE, OverridesType.toString(metaOverrides.getType()), "");
					compViewObj.put("overrides", overridesObj);
				}
				// MetaComponentView添加MetaComponentLayout的json
				JSONArray layoutArray = new JSONArray();
				Iterator<MetaComponentLayout<?>> layoutIt = metaCompView.iterator();
				while(layoutIt.hasNext()){
					MetaComponentLayout<?> metaLayout = layoutIt.next();
					layoutArray.put(builder.build(ve, builder, metaForm, metaLayout));
				}
				compViewObj.put("layouts", layoutArray);
				
				itemArray.put(compViewObj);
			}
			
			viewObj.put(JSONConstants.COMMON_ITEMS, itemArray);
			
			metaViewArray.put(viewObj);
		}
		
		json.put(JSONConstants.COMMON_ITEMS, metaViewArray);
	}

}
