package com.bokesoft.yes.mid.web.ui.load.mobiledef;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.EventDefType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDef;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundItem;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorItem;
import com.bokesoft.yigo.tools.ve.VE;

public class MobileDefJSONBuilder extends AbstractJSONBuilder<MetaMobileDef> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaMobileDef meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_CSS, meta.getCss(), "");
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_HASNAVIGATIONBAR, meta.getHasNavigationBar(), "");
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_SYSLANGUAGE, meta.isSysLanguage(), true);
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PASSENABLETIME, meta.getPassEnableTime(), 60);
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PASSERRORCOUNT, meta.getPassErrorCount(), 0);

		if (meta.getNavigationBar() != null) {
			JSONObject navigationBarObj = builder.build(ve, builder, metaForm, meta.getNavigationBar());
			json.put(JSONConstants.MOBILEDEF_NAVIGATIONBAR, navigationBarObj);
		}

		if (meta.getEventDefCollection() != null && meta.getEventDefCollection().size() > 0) {
			JSONArray eventDefArray = new JSONArray();
			for (int i = 0; i < meta.getEventDefCollection().size(); i++) {
				MetaEventDef metaEventDef = meta.getEventDefCollection().get(i);
				JSONObject eventDefObj = new JSONObject();
				JSONHelper.writeToJSON(eventDefObj, JSONConstants.COMMON_KEY, metaEventDef.getKey(), "");
				JSONHelper.writeToJSON(eventDefObj, JSONConstants.COMMON_CAPTION, metaEventDef.getCaption(), "");
				JSONHelper.writeToJSON(eventDefObj, JSONConstants.COMMON_TYPE,
						EventDefType.toString(metaEventDef.getType()), EventDefType.Str_Signal);
				eventDefArray.put(eventDefObj);
			}
			json.put(JSONConstants.MOBILEDEF_EVENTDEFCOLLECTION, eventDefArray);
		}

		if (meta.getVibratorDef() != null && meta.getVibratorDef().size() > 0) {
			JSONArray vibratorDefArray = new JSONArray();
			for (int i = 0; i < meta.getVibratorDef().size(); i++) {
				MetaVibratorItem metaVibratorItem = meta.getVibratorDef().get(i);
				JSONObject itemObj = new JSONObject();
				JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_KEY, metaVibratorItem.getKey(), "");
				JSONHelper.writeToJSON(itemObj, "milliseconds", metaVibratorItem.getMilliseconds(), 0);
				JSONHelper.writeToJSON(itemObj, "pattern", metaVibratorItem.getPattern(), "");
				JSONHelper.writeToJSON(itemObj, "repeat", metaVibratorItem.getRepeat(), -1);
				JSONHelper.writeToJSON(itemObj, "delayTime", metaVibratorItem.getDelayTime(), 0);
				vibratorDefArray.put(itemObj);
			}
			json.put(JSONConstants.MOBILEDEF_VIBRATORDEF, vibratorDefArray);

		}

		if (meta.getSoundPool() != null && meta.getSoundPool().size() > 0) {
			JSONArray soundPoolArray = new JSONArray();
			for (int i = 0; i < meta.getSoundPool().size(); i++) {
				MetaSoundItem metaSoundItem = meta.getSoundPool().get(i);
				JSONObject itemObj = new JSONObject();
				JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_KEY, metaSoundItem.getKey(), "");
				JSONHelper.writeToJSON(itemObj, "path", metaSoundItem.getPath(), "");
				JSONHelper.writeToJSON(itemObj, "leftVolume", metaSoundItem.getLeftVolume() + "", "1");
				JSONHelper.writeToJSON(itemObj, "rightVolume", metaSoundItem.getRightVolume() + "", "1");
				JSONHelper.writeToJSON(itemObj, "priority", metaSoundItem.getPriority(), 0);
				JSONHelper.writeToJSON(itemObj, "loop", metaSoundItem.getLoop(), -1);
				JSONHelper.writeToJSON(itemObj, "rate", metaSoundItem.getRate() + "", "1");
				soundPoolArray.put(itemObj);
			}
			json.put(JSONConstants.MOBILEDEF_SOUNDPOOL, soundPoolArray);
		}
	}
}
