package com.bokesoft.yes.mid.web.ui.load.control.wizardlist;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItem;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemCollection;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardList;
import com.bokesoft.yigo.tools.ve.VE;

public class WizardListJSONBuilder extends BaseComponentJSONBuilder<MetaWizardList> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaWizardList meta) throws Throwable {
		JSONObject jsonObject = super.getMetaJSON(ve, builder, metaForm, meta);
		MetaWizardItemCollection itemCollection = meta.getItemCollection();
		if (itemCollection != null && itemCollection.size() > 0) {
			JSONArray itemArray = new JSONArray();
			for (int i = 0; i < itemCollection.size(); i++) {
				MetaWizardItem item = itemCollection.get(i);
				JSONObject itemObj = builder.build(ve, builder, metaForm, item);
				itemArray.put(itemObj);
			}
			jsonObject.put(JSONConstants.COMMON_ITEMS, itemArray);
		}
		if (meta.getItemList() != null) {
			JSONObject itemListObj = builder.build(ve, builder, metaForm, meta.getItemList());
			jsonObject.put(JSONConstants.WIZARDITEM_ITEMLIST, itemListObj);
		}
		return jsonObject;
	}
}
