package com.bokesoft.yes.mid.web.ui.load.control.tabgroup;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.tools.ve.VE;

public class TabItemJSONBuilder extends AbstractJSONBuilder<MetaTabItem>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTabItem meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TEXT, meta.getText(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ITEM_SELECTEDICON, meta.getSelectedIcon(), "");
		if(meta.getAction() != null && !meta.getAction().isEmpty()){
			JSONHelper.writeToJSON(json, JSONConstants.Event_Action, meta.getAction().getContent(), "");
		}
	}

}
