package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class TextButtonPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaTextButtonProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaTextButtonProperties meta, String key) throws Throwable {

		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_MAXLENGTH, meta.getMaxLength() , 255 );
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_INVALIDCHARS, meta.getInvalidChars() , null );
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_TEXTCASE, meta.getCaseType(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, builder.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()), null);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_EMBEDTEXT, builder.getString(GroupKeyTable.STR_EMBED, "", key, meta.getEmbedText()), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_USEFORMULAMODEL, meta.getUseFormulaModel(), false);

		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim(), "");
		}

		MetaBaseScript keyEnter = meta.getKeyEnter();
		if(keyEnter != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_KeyEnter, meta.getKeyEnter().getContent().trim(), "");
		}
	}
}
