package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class PasswordEditorPropertiesJSONBuilder extends TextEditorPropertiesJSONBuilder {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaTextEditorProperties meta, String key) throws Throwable {
		super.loadImpl(ve, builder, json, metaForm, meta, key);
		MetaPasswordEditorProperties properties = (MetaPasswordEditorProperties)meta;
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SAFEINPUT, properties.isSafeInput(), false);
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SHOWSWITCHICON, properties.isShowSwitchIcon(), true);
	}
}
