package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.def.FormatStyle;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class NumberEditorPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaNumberEditorProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaNumberEditorProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECPRECISION, meta.getPrecision(), 16);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECSCALE, meta.getScale(), 2);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR, meta.isUseGroupingSeparator(), true);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SELECTONFOCUS, meta.isSelectOnFocus(), true);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ROUNDINGMODE, meta.getRoundingMode(), RoundingMode.HALF_UP);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ZEROSTRING, meta.getZeroString(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_NEGTIVEFORECOLOR, meta.getNegtiveForeColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SHOWZERO, meta.isShowZero(), false);
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, builder.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_FORMATSTYLE, FormatStyle.format(meta.getFormatStyle()), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_IMEOPTIONS, EditorImeOptions.toString(meta.getImeOptions()),"");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_STRIPTRAILINGZEROS, meta.getStripTrailingZeros(), false);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_INTEGERVALUE, meta.integerValue(), false);
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_PREFIX, meta.getPrefix(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_FORMULATEXT, meta.getFormulaText(), "");
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent(), "");
		} 
	}
}
