package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.DictItemKeySourceType;
import com.bokesoft.yigo.common.def.DictLoadType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class DictPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaDictProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaDictProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEY,  meta.getItemKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ISDYNAMIC, meta.isDynamic(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ISCOMPDICT, meta.isCompDict(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ROOT,  meta.getRoot(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ALLOWMULTISELECTION,  meta.isAllowMultiSelection(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_REFKEY, meta.getRefKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_REFDATAELEMENTKEY, meta.getRefDataElementKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_INDEPENDENT,  meta.isIndependent(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_STATEMASK,  meta.getStateMask(), DictStateMask.Enable);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEYSOURCE, meta.getItemKeySource(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEYSOURCETYPE, DictItemKeySourceType.format(meta.getItemKeySourceType()),
				DictItemKeySourceType.STR_DATAOBJECT);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_IGNORERIGHTS, meta.isIgnoreRights(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_EDITABLE, meta.isEditable(), true);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_SIDESLIP);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_LOADTYPE, meta.getLoadType(), DictLoadType.R2L);
		JSONHelper.writeToJSON(json, JSONConstants.DICT_FORMULATEXT, meta.getFormulaText(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_TEXTFIELD, meta.getTextField(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DICT_PROMPTDATA, meta.isPromptData(), false);

		MetaItemFilterCollection filters = meta.getFilters();
		if(filters != null && !filters.isEmpty()){
			JSONObject _filters = builder.build(ve, builder, metaForm, filters);
			_filters.put(JSONConstants.COMMON_FORMKEY, metaForm.getKey());
			_filters.put(JSONConstants.COMMON_FIELDKEY, key);
			json.put(JSONConstants.DICT_ITEMFILTERS, _filters);	
		}
				
		// 添加依赖
		String root = meta.getRoot();
		if(root != null && !root.isEmpty()){
			builder.addRelation(key, root);
		}
		
		// 添加依赖,这里有个问题,子明细的过滤是copy明细单元格的,所以会将明细单元格和子明细生成关系条目
		// 但其实没必要,因为明细单元格值改变会对子明细设值,但无法判断是复制的filter
		if(filters != null && !filters.isEmpty()){
			for(MetaItemFilter itemFilter : filters){
				for(MetaFilter filter : itemFilter){
					builder.addRelations(key,filter.getDependedFields());
				}
			}
		}
	}

}

