package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.CountDownViewStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class CountDownViewPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaCountDownViewProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaCountDownViewProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_STYLE, meta.getStyle(), CountDownViewStyle.RECTANGLE);
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_STEPPER, meta.getStepper(), 1);
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_MAXTIME, meta.getMaxTime(),
				MetaCountDownViewProperties.DEFAULT_MAX_TIMER);
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_REPEAT, meta.isRepeat(), false);
		if (meta.getOnClick() != null && !meta.getOnClick().isEmpty()) {
			JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_ONCLICK, meta.getOnClick().getContent(), "");
		}
		if (meta.getOnFinish() != null && !meta.getOnFinish().isEmpty()) {
			JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_ONFINISH, meta.getOnFinish().getContent(), "");
		}
	}

}
