package com.bokesoft.yes.mid.web.ui.load.control.listlayoutview;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayout;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayoutCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class RowLayoutCollectionJSONBuilder extends AbstractJSONBuilder<MetaRowLayoutCollection> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm,
			MetaRowLayoutCollection meta) throws Throwable {

		Iterator<MetaRowLayout> itColumnDef = meta.iterator();
		MetaRowLayout metaRowLayout = null;
		JSONArray raoLayouts = new JSONArray();
		while (itColumnDef.hasNext()) {
			metaRowLayout = itColumnDef.next();
			JSONObject rowLayoutJSON = builder.build(ve, builder, metaForm, metaRowLayout);
			raoLayouts.put(rowLayoutJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, raoLayouts);
	}

}
