package com.bokesoft.yes.mid.web.ui.load.control.editview;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumnCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class EditViewJSONBuilder extends BaseComponentJSONBuilder<MetaEditView> {
	
	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaEditView meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		// 载入行定义 
		MetaEditViewColumnCollection listViewColumnCollection = meta.getColumnCollection();
		if(listViewColumnCollection != null){
			JSONObject columnDefCollectionJSON = builder.build(ve, builder, metaForm, listViewColumnCollection);
			metaJSON.put(JSONConstants.LISTVIEW_COLUMNINFO, columnDefCollectionJSON.getJSONArray(JSONConstants.COMMON_ITEMS));
		}
		if(meta.getRow() != null){
			JSONObject rowObject = builder.build(ve, builder, metaForm, meta.getRow());
			metaJSON.put(JSONConstants.LISTVIEW_ROWINFO, rowObject);
		}
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_COLUMN_HASSELECTFIELD, meta.hasSelectField(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_SELECTFIELDINDEX, meta.getSelectFieldIndex(), -1);
		
		metaJSON.put("primaryKeys", MetaUtil.getPrimaryKeys(ve.getMetaFactory(),metaForm, meta.getTableKey()));

		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_DEFAULTSELECTROW, meta.getDefaultSelectRow(), -1);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_PAGELOADTYPE, meta.getPageLoadType(), PageLoadType.NONE);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_PAGEROWCOUNT, meta.getPageRowCount(), 50);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_PROMPTROWCOUNT, meta.getPromptRowCount(), meta.getDefaultPromptRowCount());
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_ITEMANIM, meta.getItemAnim(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_LAYOUTANIM, meta.getLayoutAnim(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_ROWHEIGHT, meta.getRowHeight(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TABPANEL_SHOWHEAD, meta.isShowHead(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TILEDLIST_ORIENTATION, meta.getOrientation(), meta.getDefaultOrientation());
		String rowBackColor = meta.getRowBackColor();
		if (rowBackColor != null){
		    JSONHelper.writeToJSON(metaJSON, JSONConstants.LISTVIEW_ROWBACKCOLOR, rowBackColor, "");
		}
		MetaBaseScript click = (MetaBaseScript) meta.getRowClick();
		if(click != null) {
			metaJSON.put(JSONConstants.Event_RowClick, click.getContent().trim());
		}
		
		MetaBaseScript dbClick = meta.getRowDblClick();
		if(dbClick != null){
			metaJSON.put(JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}
		
		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if(rowChange != null){
			metaJSON.put(JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}
	
		return metaJSON;
	}

}
