package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;
import com.bokesoft.yigo.tools.ve.VE;

public class ShrinkViewJSONBuilder extends BaseComponentJSONBuilder<MetaShrinkView>{

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaShrinkView meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.SHRINKVIEW_TOOLBARBACKCOLOR, meta.getToolBarBackColor(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.SHRINKVIEW_TOOLBARHEIGHT, 
				meta.getToolBarHeight() == null ? "" : meta.getToolBarHeight().toString(), "");
		if(meta.getRoot() != null){
			metaJSON.put(JSONConstants.SHRINKVIEW_ROOT, builder.build(ve, builder, metaForm, meta.getRoot()));
		}
		if(meta.getCollapseView() != null){
			JSONObject collapseViewObj = new JSONObject();
			JSONHelper.writeToJSON(collapseViewObj, "initExpand", meta.getCollapseView().isInitExpand(), true);
			collapseViewObj.put(JSONConstants.BODY_ROOT, builder.build(ve, builder, metaForm, meta.getCollapseView().getRoot()));
			metaJSON.put(JSONConstants.SHRINKVIEW_COLLAPSEVIEW, collapseViewObj);
		}
		if(meta.getToolBarCollapse() != null){
			metaJSON.put(JSONConstants.SHRINKVIEW_TOOLBARCOLLAPSE, builder.build(ve, builder, metaForm, meta.getToolBarCollapse().getRoot()));
		}
		if(meta.getToolBarExpand() != null){
			metaJSON.put(JSONConstants.SHRINKVIEW_TOOLBAREXPAND, builder.build(ve, builder, metaForm, meta.getToolBarExpand().getRoot()));
		}
		if(meta.getOperationBar() != null){
			metaJSON.put(JSONConstants.SHRINKVIEW_OPERATIONBAR, builder.build(ve, builder, metaForm, meta.getOperationBar().getRoot()));
		}
		return metaJSON;
	}
}
