package com.bokesoft.yes.mid.web.ui.load.control;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.ChartSourceType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.chart.MetaCategory;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartDataSource;
import com.bokesoft.yigo.meta.form.component.chart.MetaSeries;
import com.bokesoft.yigo.tools.ve.VE;

public class ChartJSONBuilder extends BaseComponentJSONBuilder<MetaChart> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaChart meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		MetaChartDataSource dataSource = meta.getDataSource();
		if(dataSource != null){
			JSONObject dsJSON = new JSONObject();
			
			MetaCategory category = dataSource.getCategory();
			JSONObject categoryJSON = new JSONObject();
			categoryJSON.put("dataKey", category.getDataKey());
			dsJSON.put("category", categoryJSON);
			
			List<MetaSeries> list = dataSource.getSeriesArray();
			JSONArray array = new JSONArray();
			JSONObject seriesJSON = null;
			for(MetaSeries series : list){
				seriesJSON = new JSONObject();
				
				seriesJSON.put("splitDataKey", series.getSplitDataKey());
				seriesJSON.put("dataKey", series.getDataKey());

				seriesJSON.put("title", builder.getString(GroupKeyTable.STR_CHART, meta.getKey(), "Series-"+series.getDataKey(), series.getTitle()));
				array.put(seriesJSON);
			}
				
			dsJSON.put("series", array);
			dsJSON.put("bindingKey", dataSource.getBindingKey());
			metaJSON.put("dataSource", dsJSON);
		}
		
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_CHARTTYPE, meta.getChartType() , -1 );
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_SOURCETYPE, ChartSourceType.toString(meta.getSourceType()) , "" );
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_TITLE, builder.getString(GroupKeyTable.STR_CHART,
				meta.getKey(), "Title", meta.getTitle()) , "" );
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_SERICESINROW, meta.getSeriesInRow() , false );
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_SERICESAXISTITLE, builder.getString(GroupKeyTable.STR_CHART,
				meta.getKey(), "SeriesAxisTitle", meta.getSeriesAxisTitle()) , "" );		
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_CATEGORYAXISTITLE, builder.getString(GroupKeyTable.STR_CHART,
				meta.getKey(), "CategoryAxisTitle", meta.getCategoryAxisTitle()) , "" );
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_SHOWVALUES, meta.isShowValue(), true);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_FILL, meta.isFill(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHART_HASANIMATION, meta.isHasAnimation(), false);
		return metaJSON;
	}
	
}
