package com.bokesoft.yes.mid.web.ui.load;

import java.util.ArrayList;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.PropertiesJSONBuilderMap;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.datamap.MetaDataMapList;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaTimerTask;
import com.bokesoft.yigo.meta.form.MetaTimerTaskCollection;
import com.bokesoft.yigo.meta.form.MetaVariant;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class FormJSONBuilder extends AbstractJSONBuilder<MetaForm> {

	private MetaForm metaForm = null;
	private VE ve = null;
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaForm meta)
			throws Throwable {
		this.metaForm = metaForm;
		this.ve = ve;

		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PROJECTKEY, meta.getProject().getKey(), "");
		
		String caption = builder.getString(GroupKeyTable.STR_UI, "", meta.getKey(),  meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption, "");
		JSONHelper.writeToJSON(json, JSONConstants.FORM_TEMPLATEKEY, meta.getTemplateKey(), "");
		
		caption = builder.getString(GroupKeyTable.STR_UI, "", meta.getKey()+"-Abbr",  meta.getAbbrCaption());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ABBRCAPTION, caption, "");
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FORMULACAPTION, meta.getFormulaCaption(), "");
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FORMULAABBRCAPTION, meta.getFormulaAbbrCaption(), "");
		json.put(JSONConstants.FORM_OPERATIONSTATE, OperationState.Edit);
		json.put(JSONConstants.FORM_INITSTATE, meta.getInitState());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getFormType(), FormType.Normal);
		JSONHelper.writeToJSON(json, JSONConstants.FORM_AUTHENTICATE, meta.isAuthenticate(), false);
		JSONHelper.writeToJSON(json, JSONConstants.FORM_INITFOCUS, meta.initFocus(), true);
		JSONHelper.writeToJSON(json, JSONConstants.FORM_CONFIRMCLOSE , meta.isConfirmClose(), false);
		json.put(JSONConstants.FORM_VERSION, meta.getVersion());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_USERDATA, meta.getUserData(), "");
		
		MetaBaseScript onLoad = meta.getOnLoad();
		if(onLoad != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_ONLOAD, onLoad.getContent().trim(), "");
		}
		
		MetaBaseScript onClose = meta.getOnClose();
		if(onClose != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_ONCLOSE, onClose.getContent().trim(), "");
		}
		
		MetaScript loadScript = MetaUtil.getLoadScript(ve.getMetaFactory(),meta);
		MetaScript saveScript = MetaUtil.getSaveScript(ve.getMetaFactory(),meta);
		
		JSONObject scriptCollection = new JSONObject();
		if(loadScript != null){
			scriptCollection.put(JSONConstants.SCRIPT_LOAD, loadScript.getContent());
		}
		
		if(saveScript != null){
			scriptCollection.put(JSONConstants.SCRIPT_SAVE, saveScript.getContent());
		}
		json.put(JSONConstants.FORM_SCRIPTCOLLECTION, scriptCollection);
		
		//TimerTask传递到前台的参数
		MetaTimerTaskCollection timertaskcol = meta.getTimerTaskCollection();
		if (timertaskcol != null) {
		    JSONObject timerTask = new JSONObject();
		    MetaTimerTask metaTask = null;
			for (int i = 0;i < timertaskcol.size();i++) {
			    JSONObject timerTaskchild = new JSONObject();
			    metaTask = timertaskcol.get(i);
				JSONHelper.writeToJSON(timerTaskchild, JSONConstants.COMMON_KEY, metaTask.getKey(), "");
				JSONHelper.writeToJSON(timerTaskchild, JSONConstants.TIMERTASK_DELAY, metaTask.getDelay(), 0);
				JSONHelper.writeToJSON(timerTaskchild, JSONConstants.TIMERTASK_PERIOD, metaTask.getPeriod(), 60000);
				JSONHelper.writeToJSON(timerTaskchild, JSONConstants.TIMERTASK_CONTENT, metaTask.getContent(), "");
				JSONHelper.writeToJSON(timerTaskchild, JSONConstants.TIMERTASK_REPEAT, metaTask.isRepeat(), false);
				timerTaskchild.put(JSONConstants.TIMERTASK_STARTONLOAD, metaTask.startOnload());
			    timerTask.put(metaTask.getKey(), timerTaskchild);
			}
			json.put(JSONConstants.FORM_TimerTaskCollection,  timerTask);
		}
		
		MetaDataSource dataSource = meta.getDataSource();
		JSONObject d = new JSONObject();
		if(dataSource != null) {
			MetaDataObject db = dataSource.getDataObject();
			if(db != null) {
				d.put(JSONConstants.COMMON_KEY, db.getKey());
				d.put(JSONConstants.DATAOBJECT_PRIMARYTYPE, db.getPrimaryType());
				d.put(JSONConstants.DATAOBJECT_SECONDARYTYPE, db.getSecondaryType());
				d.put(JSONConstants.DATAOBJECT_VERSION, db.getVersion());
				
				json.put(JSONConstants.FORM_MAINTABLEKEY, db.getMainTableKey());
			}
		}
		json.put(JSONConstants.FORM_DATAOBJECT, d);
		
		//这个地方是个BUG ， 但这个BUG 没什么大问题。
		MetaMacroCollection macroCollection = MetaUtil.getMacroCollection(ve.getMetaFactory(),metaForm);
		
		if (macroCollection != null && !macroCollection.isEmpty()) {
			JSONObject macroMap = new JSONObject();
			for(int i=0;i<macroCollection.size();i++){
				MetaMacro metaMacro = macroCollection.get(i);
				JSONObject macroObj = new JSONObject();
				macroObj.put(JSONConstants.MACROMAP_ARGS, metaMacro.getArgsList());
				JSONHelper.writeToJSON(macroObj, JSONConstants.COMMON_KEY, metaMacro.getKey(), "");
				JSONHelper.writeToJSON(macroObj, JSONConstants.MACROMAP_CONTENT, metaMacro.getContent(), "");
				macroMap.put(metaMacro.getKey(), macroObj);
			} 
			json.put(JSONConstants.FORM_MACROMAP, macroMap);
		}
		
		json.put(JSONConstants.FORM_OPERATIONS, getOperations(ve, builder, meta));
		
		MetaBaseScript onPostShow = meta.getOnPostShow();
		if (onPostShow != null && !onPostShow.isEmpty()) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_POSRSHOW, onPostShow.getContent().trim(), "");
		}

		MetaBody metaBody = meta.getMetaBody();
		JSONObject bodyJson = builder.build(ve, builder, metaForm, metaBody);
		json.put(JSONConstants.COMMON_BODY, bodyJson);
		if(metaBody.getPopWidth() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_POPWIDTH, metaBody.getPopWidth().toString(), "");
		}
		if(metaBody.getPopHeight() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_POPHEIGHT, metaBody.getPopHeight().toString(), "");
		}
		if(metaBody.getTopMargin() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_TOPMARGIN, metaBody.getTopMargin().getSize(), 0);
		}
		if(metaBody.getBottomMargin() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_BOTTOMMARGIN, metaBody.getBottomMargin().getSize(), 0);
		}
		if(metaBody.getLeftMargin() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_LEFTMARGIN, metaBody.getLeftMargin().getSize(), 0);
		}
		if(metaBody.getRightMargin() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_RIGHTMARGIN, metaBody.getRightMargin().getSize(), 0);
		}
		
		try {
			JSONObject mapGrids = new JSONObject();
			MetaDataMapList dataMapList = ve.getMetaFactory().getDataMapList();
			if(meta.getDataSource() == null 
					|| meta.getDataSource().getDataObject() == null) return;
			String dataObjectKey = meta.getDataSource().getDataObject().getKey();
			ArrayList<String> dataMaps = dataMapList .getDMListBySrcDataObjectKey(dataObjectKey);
			for (int i = 0; i < dataMaps.size(); i++) {
				String dataMapKey = dataMaps.get(i);
				try {
					MetaMap metaMap = ve.getMetaFactory().getDataMap(dataMapKey);
					String tableKey = metaMap.getDataMapParas( ve.getMetaFactory()).getPrimarySourceTableKey();
					mapGrids.put(metaMap.getKey(), tableKey);
				} catch (Exception e) {
					// TODO: handle exception
				}
				
			}
			json.put(JSONConstants.FORM_MAPGRIDS, mapGrids);
		} catch (Throwable e) {
			e.printStackTrace();
		}
		
		// 动态单元格		
		MetaCellTypeTable table = ve.getMetaFactory().getCellTypeTable();
		MetaCellTypeGroup group = table.get(metaForm.getKey());
		
		if( group != null ) {
			JSONObject groupJson = new JSONObject();
			Iterator<MetaCellTypeDef> groupIt = group.iterator();
			while (groupIt.hasNext()) {
				MetaCellTypeDef def = groupIt.next();
				groupJson.put(def.getKey(), toCellTypeDefJSON(ve, builder, metaForm, def));
			}
			json.put("cellTypeGroup", groupJson);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ANIM, meta.getAnimationType(), "");
		if(meta.getAnimCollection() != null && meta.getAnimCollection().size() > 0){
			JSONObject animCollectionObj = builder.build(ve, builder, metaForm, meta.getAnimCollection());
			json.put("animCollection", animCollectionObj);
		}
		
		if(meta.getMetaNavigation() != null){
			JSONObject navigationBarObj = builder.build(ve, builder, metaForm, meta.getMetaNavigation());
			json.put("navigationBar", navigationBarObj);
		}
		
		// 变体设置
		MetaVariant metaVariant = metaForm.getVariant();
		if( metaVariant != null ) {
//			json.put("variant", metaVariant.toJSON());
		}
	}
	
	private static JSONObject toCellTypeDefJSON(VE ve,IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaCellTypeDef typeDef) throws Throwable {
		JSONObject cellObj = new JSONObject();
		String key = typeDef.getKey();
		
		int cellType = typeDef.getType();
		
		cellObj.put("key", typeDef.getKey());
		cellObj.put("caption", typeDef.getCaption());
		cellObj.put("cellType", typeDef.getType());
		
		if (typeDef.getCondition() != null) {
			cellObj.put("tableKey", typeDef.getCondition().getTableKey());
			cellObj.put("columnKey", typeDef.getCondition().getColumnKey());
		}
		
		JSONObject options = new JSONObject();
	
		PropertiesJSONBuilder<AbstractMetaObject> propertesbuilder = PropertiesJSONBuilderMap.getBuilder(cellType);
		
		if(propertesbuilder != null) {
			propertesbuilder.load(ve, builder, options, metaForm, typeDef.getProperties(), typeDef.getKey());
		}
		
		options.put("cellType", cellType);
		
		cellObj.put("editOptions", options);
		
		switch (cellType) {
		case ControlType.LABEL:
			JSONHelper.writeToJSON(cellObj, "formatter", "label", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.TEXTEDITOR:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.NUMBEREDITOR:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.DATEPICKER:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.UTCDATEPICKER:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.CHECKLISTBOX:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			JSONHelper.writeToJSON(options, "key", key, "");
			break;
		case ControlType.COMBOBOX:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			
			JSONHelper.writeToJSON(options, "key", key, "");
			break;
		case ControlType.DICT:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			JSONHelper.writeToJSON(options, "key", key, "");
			break;
		case ControlType.DYNAMICDICT:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			JSONHelper.writeToJSON(options, "key", key, "");
			break;
		case ControlType.COMPDICT:
			break;
		case ControlType.CHECKBOX:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "checkbox", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.BUTTON:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "button", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);		
			break;
		case ControlType.HYPERLINK:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "hyperlink", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.IMAGE:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "image", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.TEXTBUTTON:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.MONTHPICKER:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		case ControlType.TIMEPICKER:
			JSONHelper.writeToJSON(cellObj, "formatter", "custom", "");
			JSONHelper.writeToJSON(cellObj, "customedit", true, false);
			break;
		default:
			break;
		}

		return cellObj;
	}
	
	private JSONArray getOperations(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm meta) throws Throwable {
		MetaOperationCollection metaOperationCollection = meta.getOperationCollection();
		JSONArray options = new JSONArray();
		if( metaOperationCollection == null )
			return options;
		
		Iterator<KeyPairCompositeObject> it = metaOperationCollection.iterator();
		while (it.hasNext()) {
			KeyPairCompositeObject metaItem = it.next();
			JSONObject option = new JSONObject();
			if ( metaItem.getObjectType() == MetaOperation.Operation ) {
				MetaOperation metaOperation = (MetaOperation)metaItem;
				String tag = metaOperation.getTag();
				if (tag != null && !tag.isEmpty()) {
					option.put(JSONConstants.OPERATION_TAG, tag);
				}
				addOneOperation(builder, metaOperation, option);
			} else {
				addOneMenuOperation(builder, (MetaOperationCollection)metaItem, option);
			}
			options.put(option);
		}
		
		return options;
	}
	
	private void addOneOperation(IRootJSONBuilder<AbstractMetaObject> builder, MetaOperation metaOperation, JSONObject option) throws Throwable {
		// 处理refKey，即引用父定义的操作
		String refKey = metaOperation.getRefKey();
		if ( refKey != null && !refKey.isEmpty() ) {
			if ( !metaOperation.isRefKeyInited() ) {
				MetaUtil.processOperationRefKey(this.ve.getMetaFactory(), metaForm, metaOperation);
			}
			option.put(JSONConstants.OPERATION_REFKEY, refKey);
		}
		
		option.put(JSONConstants.COMMON_KEY, metaOperation.getKey());
		String caption = builder.getString(GroupKeyTable.STR_OPT, "", metaOperation.getKey(), metaOperation.getCaption());
		option.put(JSONConstants.COMMON_CAPTION, caption);
		option.put(JSONConstants.OPERATION_VISIBLECNT, metaOperation.getVisible());
		option.put(JSONConstants.COMMON_VISIBLEDEPENDENCY, metaOperation.getVisibleDependency());
		option.put(JSONConstants.OPERATION_ENABLECNT, metaOperation.getEnable());
		option.put(JSONConstants.COMMON_ENABLEDEPENDENCY, metaOperation.getEnableDependency());
		option.put(JSONConstants.OPERATION_TYPE, metaOperation.getObjectType());
		option.put(JSONConstants.OPERATION_CSSCLASS, metaOperation.getCssClass());
		if(metaOperation.getAction() != null) {
			option.put(JSONConstants.OPERATION_ACTION, metaOperation.getAction().getContent().trim());
		}
		MetaBaseScript preAction = metaOperation.getPreAction();
		if (preAction != null && !preAction.isEmpty()) {
			option.put(JSONConstants.OPERATION_PREACTION, preAction.getContent().trim());
		}
		option.put(JSONConstants.OPERATION_ICON, metaOperation.getIcon());
		
		option.put(JSONConstants.OPERATION_SHORTCUTS, metaOperation.getShortCuts());
		
		option.put(JSONConstants.OPERATION_MANAGED, metaOperation.isManaged());
		MetaBaseScript excepAction = metaOperation.getExceptionHandler();
		if( excepAction != null && !excepAction.isEmpty() ) {
			option.put(JSONConstants.OPERATION_EXCPACTION, excepAction.getContent().trim());			
		}
		option.put(JSONConstants.OPERATION_EXPAND, metaOperation.isExpand());
		if(metaOperation.isExpand()){
			option.put(JSONConstants.OPERATION_EXPANDSOURCE, metaOperation.getExpandSource());
		}
		
		option.put(JSONConstants.COMMON_TCODE, metaOperation.getTCode());
		option.put(JSONConstants.COMMON_ACTIVITY, metaOperation.getActivity());
	}
	
	private void addOneMenuOperation(IRootJSONBuilder<AbstractMetaObject> builder, MetaOperationCollection collection, JSONObject operation) throws Throwable {
		operation.put(JSONConstants.COMMON_KEY, collection.getKey());
		String caption = builder.getString(GroupKeyTable.STR_OPT, "", collection.getKey(), collection.getCaption());
		operation.put(JSONConstants.COMMON_CAPTION, caption);
		operation.put(JSONConstants.OPERATION_VISIBLECNT, collection.getVisible());
		operation.put(JSONConstants.COMMON_VISIBLEDEPENDENCY, collection.getVisibleDependency());
		operation.put(JSONConstants.OPERATION_ENABLECNT, collection.getEnable());
		operation.put(JSONConstants.COMMON_ENABLEDEPENDENCY, collection.getEnableDependency());
		operation.put(JSONConstants.OPERATION_TYPE, collection.getObjectType());
		operation.put(JSONConstants.OPERATION_ICON, collection.getIcon());
		operation.put(JSONConstants.OPERATION_SELFDISABLE, collection.isSelfDisable());
		operation.put(JSONConstants.OPERATION_CSSCLASS, collection.getCssClass());
		if(collection.getAction() != null) {
			operation.put(JSONConstants.OPERATION_ACTION, collection.getAction().getContent().trim());
		}
		Iterator<KeyPairCompositeObject> it = collection.iterator();
		KeyPairCompositeObject metaCompositeObject = null;
		JSONArray items = new JSONArray();
		while (it.hasNext()) {
			metaCompositeObject = it.next();
			if(metaCompositeObject.getObjectType() == MetaOperation.Operation){
				MetaOperation metaOperation = (MetaOperation)metaCompositeObject;
				JSONObject operationJSON = new JSONObject();
				addOneOperation(builder, metaOperation, operationJSON);
				items.put(operationJSON);
			}else if(metaCompositeObject.getObjectType() == MetaOperation.OperationCollection){
				MetaOperationCollection metaOperationCollection = (MetaOperationCollection)metaCompositeObject;
				JSONObject operationCollectionObj = new JSONObject();
				addOneMenuOperation(builder, metaOperationCollection, operationCollectionObj);
				items.put(operationCollectionObj);
			}
		}
		operation.put(JSONConstants.COMMON_ITEMS, items);
	}
}
