package com.bokesoft.yes.mid.web.ui.load;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.tools.ve.VE;

public abstract class BasePanelJSONBuilder<T extends MetaPanel> extends BaseComponentJSONBuilder<T> {
	
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, T meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.COMMON_CANRECEIVEFOCUS, false);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_AUTO);
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_OVERFLOWX, ScrollType.toString(meta.getOverflowX()), "");
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_OVERFLOWY, ScrollType.toString(meta.getOverflowY()), "");
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGE, meta.getBackImage(), "");
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEPOSITION, DirectionType.toString(meta.getBackImagePosition()), "");
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEREPEATX, meta.isBackImageRepeatX(), false);
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEREPEATY, meta.isBackImageRepeatY(), false);

		MetaBaseScript check = meta.getCheck();
		if( check != null ) {
			json.put(JSONConstants.BASEPANEL_CHECK, check.getContent().trim());
		}
		MetaBaseScript leave = meta.getLeave();
		if( leave != null ) {
			json.put(JSONConstants.BASEPANEL_LEAVE, leave.getContent().trim());
		}
	}
}
