package com.bokesoft.yes.mid.web.cmd;

import java.io.ByteArrayOutputStream;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.util.PrintPDF;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class PrintGridPDFCmd extends DefaultServiceCmd{

	private String formKey = null;
		
	private OutputSection gridSection = null;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
				
		gridSection = new OutputSection();
		String str = TypeConvertor.toString(arguments.get("section"));
		JSONObject json = new JSONObject(str);
		gridSection.fromJSON(json);
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		ByteArrayOutputStream baos = null;
		try {
			PrintPDF print = new PrintPDF(formKey, false);
			baos = print.printGridPdf(context, gridSection);
			
			return new String(Base64.encode(baos.toByteArray()));
		} finally {
			if( baos != null ) {
				baos.close();
			}
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {		
		return new PrintGridPDFCmd();
	}

	@Override
	public String getCmd() {		
		return "PrintGrid";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}