package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetReportCmd extends DefaultServiceCmd {

	private String formKey = null;
	private String groupKey = null;
	private String reportKey = null;
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		groupKey = TypeConvertor.toString(arguments.get("groupKey"));
		reportKey = TypeConvertor.toString(arguments.get("reportKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaReport report = metaFactory.getReport(groupKey, formKey, reportKey);
		if( report != null ) {
			return ReportJSONHandlerUtil.build(report, new SolutionSerializeContext(context.getVE()));
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetReportCmd();
	}

	@Override
	public String getCmd() {
		return "GetForm";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
