package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormRelation;
import com.bokesoft.yigo.meta.form.MetaFormRelationCollection;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.i18n.I18NInfo;

public class GetRelationFormCmd extends DefaultServiceCmd {

	private String formKey = null;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm form = metaFactory.getMetaForm(this.formKey);
		MetaFormRelationCollection formRelationCollection = form.getFormRelationCollection();
		String sRet = "";
		String key;
		String caption;
		MetaForm f;
		if (formRelationCollection != null) {
			for (MetaFormRelation formRelation : formRelationCollection) {
				key = formRelation.getFormKey();
				f = context.getVE().getMetaFactory().getMetaForm(key);
				MetaLang metaLang = metaFactory.getSolution().getLangConfig().get(context.getEnv().getLocale());
				caption = I18NInfo.getInstance().getCaptionString(metaFactory, context.getEnv().getLocale(),
						form.getProjectKey(), null, null, f.getCaption(), metaLang, null);
				sRet += ";" + key + "," + caption;
			}
		}
		if (sRet.length() > 0) {
			sRet = sRet.substring(1);
		}
		return sRet;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetRelationFormCmd();
	}

	@Override
	public String getCmd() {
		return "GetRelationForm";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
