package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.session.DefaultSessionCheck;
import com.bokesoft.yes.mid.web.ui.WebJSONUIBuilder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;
import org.json.JSONObject;

public class GetFormCmd extends DefaultServiceCmd {

	private String formKey = null;
	private String templateKey = null;
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		templateKey = TypeConvertor.toString(arguments.get("templateKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = null;
		if(templateKey != null && !templateKey.isEmpty()){
			metaForm = metaFactory.getMetaForm(formKey, templateKey);
		}else{
			metaForm = metaFactory.getMetaForm(formKey);
		}
		
		MidVEHost veHost = new MidVEHost(context);
		veHost.setVE(context.getVE());
		
		WebJSONUIBuilder builder = new WebJSONUIBuilder();
		builder.setVEHost(veHost);
		builder.setMetaForm(metaForm);
		JSONObject formJson = builder.build();

		//前台扩展表单合并处理
		IExtensionProvider provider = ExtensionUtil.newProvider();
		if(provider != null){
			MetaForm extForm = provider.getExtMetaForm(context, metaForm);
			if (extForm != null) {
				WebJSONUIBuilder extFormBuilder = new WebJSONUIBuilder();
				extFormBuilder.setVEHost(veHost);
				extFormBuilder.setMetaForm(extForm);
				JSONObject extFormJSON = extFormBuilder.build();
				JSONObject mergeInfo = new JSONObject();
				JSONHelper.writeToJSON(mergeInfo, JSONConstants.FORM_FORMINFO, extFormJSON);
				JSONHelper.writeToJSON(formJson, JSONConstants.FORM_DELAYMERGEINFO, mergeInfo);
			}
		}

		return formJson;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetFormCmd();
	}

	@Override
	public String getCmd() {
		return "GetForm";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
