package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetDynamicCellKeyCmd extends DefaultServiceCmd{
	private String formKey = "";
	private String field = "";
	private int sign = -1;
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
		field = (String) arguments.get("field");
		sign = TypeConvertor.toInteger(arguments.get("sign"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);

		int controlType = -1;
		if (metaForm != null) {				
			MetaComponent meta = metaForm.componentByKey(field);
			if(meta != null){
				controlType = meta.getControlType();
			}else {
				MetaGridCell metaCell = metaForm.metaGridCellByKey(field);
				if (metaCell != null) {
					controlType = metaCell.getCellType();
				}
			}				
		}
		
		String cellKey = field;
		switch (controlType) {
		case ControlType.COMBOBOX:				
		case ControlType.DICT:
		case ControlType.NUMBEREDITOR:
			if (sign == CondSign.IN) {
				cellKey += ".in";
			}
		}			
		return cellKey;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetDynamicCellKeyCmd();
	}

	@Override
	public String getCmd() {
		return "GetDynamicCellKey";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}

