package com.bokesoft.yes.mid.web.cmd;

import java.io.ByteArrayOutputStream;

import org.json.JSONObject;

import com.bokesoft.yes.automap.print.template.ReportDomUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.util.PrintPDF;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.common.util.UIUtil;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class AutoPrintPDFCmd extends DefaultServiceCmd {
	private Document doc = null;
	private String formKey = null;
	private boolean fillEmptyPrint = false;
	private AbstractRuntimeUIConfig runtimeUIConfig;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		String str = TypeConvertor.toString(arguments.get("doc"));
	
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		
		doc = new Document(null, -1);
		JSONObject json = new JSONObject(str);
		doc.fromJSON(json);
		
		fillEmptyPrint = TypeConvertor.toBoolean(arguments.get("fillEmptyPrint"));
		String uiconfig = TypeConvertor.toString(arguments.get("uiconfig"));
		if (!StringUtil.isBlankOrNull(uiconfig) && !"{}".equals(uiconfig)) {
			JSONObject jsonUI = new JSONObject(uiconfig);
			runtimeUIConfig = UIUtil.createRuntimeConfig(jsonUI);
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataObject dataObject = MetaUtil.getDataObject(metaFactory, metaForm);
		MetaReport metaReport = ReportDomUtil.createDefaultReport(metaForm.getKey(), metaForm.getCaption(), metaForm, dataObject,
				MetaUtil.getStatusCollection(metaFactory, dataObject));

		if ( metaReport == null ) {
			throw new MetaException(MetaException.NO_PRINT_TEMPLATE_DEFINED,
					SimpleStringFormat.format(StringTable.getString(context.getVE().getEnv(),  "", StringTable.NoPrintTemplateDefined), formKey));
		}
		
		ByteArrayOutputStream baos = null;
		
		try {
			PrintPDF print = new PrintPDF(formKey, metaReport, fillEmptyPrint);
			baos = print.printPDF(context, doc, runtimeUIConfig);
			
			return new String(Base64.encode(baos.toByteArray()));
		} finally {
			if( baos != null ) {
				baos.close();
			}
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new AutoPrintPDFCmd();
	}

	@Override
	public String getCmd() {
		return "AutoPrintPDF";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
	
}