/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.auth;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;
import org.json.JSONObject;

public class TouristLoginCmd
extends DefaultServiceCmd {
    private int mode = 1;

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        if (stringHashMap.containsKey((Object)"mode")) {
            this.mode = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"mode"));
        }
    }

    public String getCmd() {
        return "TouristLogin";
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        Env env = defaultContext.getVE().getEnv();
        String string = env.getClientID();
        ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)this.mode);
        if (iSessionInfoProvider == null) {
            throw new SessionException(5, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)5, (Object[])new Object[0]));
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setClientID(string);
        sessionInfo.setOperatorID(24L);
        sessionInfo.setIP(env.getClientIP());
        sessionInfo.setLoginTime(DateUtil.getNowTime());
        sessionInfo.setLastActiveTime(DateUtil.getNowTime());
        sessionInfo.setMode(this.mode);
        sessionInfo.getRoleIDList().add(12L);
        sessionInfo.setAuthenticated(false);
        iSessionInfoProvider.getSessionInfoMap().put(string, (ISessionInfo)sessionInfo);
        env = new JSONObject();
        env.put("clientID", (Object)string);
        env.put("UserID", 24L);
        env.put("Time", sessionInfo.getLoginTime().getTime());
        try {
            defaultContext = defaultContext.getDictCache().getItem("Operator", 24L);
            if (defaultContext != null) {
                env.put("Name", defaultContext.getValue("Name"));
            }
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return env;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new TouristLoginCmd();
    }
}

