/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.output;

import com.bokesoft.yes.report.output.OutputBorder;
import com.bokesoft.yes.report.output.OutputFont;
import com.bokesoft.yes.report.output.OutputImageStyle;
import com.bokesoft.yes.report.output.U;
import com.bokesoft.yes.report.util.ReportUtil;
import com.bokesoft.yigo.common.json.JSONSerializable;
import org.json.JSONObject;

public class OutputDisplay
implements JSONSerializable {
    private OutputFont font = null;
    private OutputBorder border = null;
    private OutputImageStyle imageStyle = null;
    private int verticalAlignment = 1;
    private int horizontalAlignment = 1;
    private String showType = "";
    private String encodingType = "";
    private String errorCorrectionLevel = "";
    private int margin = 0;
    private int[] padding = new int[]{0, 0, 0, 0};

    public void setFont(OutputFont outputFont) {
        this.font = outputFont;
    }

    public OutputFont getFont() {
        return this.font;
    }

    public OutputBorder getBorder() {
        return this.border;
    }

    public void setBorder(OutputBorder outputBorder) {
        this.border = outputBorder;
    }

    public void setImageStyle(OutputImageStyle outputImageStyle) {
        this.imageStyle = outputImageStyle;
    }

    public OutputImageStyle getImageStyle() {
        return this.imageStyle;
    }

    public OutputImageStyle ensureImageStyle() {
        if (this.imageStyle == null) {
            this.imageStyle = new OutputImageStyle();
        }
        return this.imageStyle;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setShowType(String string) {
        this.showType = string;
    }

    public String getShowType() {
        return this.showType;
    }

    public void setEncodingType(String string) {
        this.encodingType = string;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public void setErrorCorrectionLevel(String string) {
        this.errorCorrectionLevel = string;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        this.margin = n;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setPadding(int[] nArray) {
        this.padding[0] = nArray[0];
        this.padding[1] = nArray[1];
        this.padding[2] = nArray[2];
        this.padding[3] = nArray[3];
    }

    public void setPadding(String string) {
        this.padding = ReportUtil.getPaddingByStr(string);
    }

    public OutputDisplay clone() {
        OutputDisplay outputDisplay = new OutputDisplay();
        outputDisplay.setFont(this.font == null ? null : this.font.clone());
        outputDisplay.setBorder(this.border == null ? null : this.border.clone());
        outputDisplay.setVerticalAlignment(this.verticalAlignment);
        outputDisplay.setHorizontalAlignment(this.horizontalAlignment);
        outputDisplay.setShowType(this.showType);
        outputDisplay.setEncodingType(this.encodingType);
        outputDisplay.setErrorCorrectionLevel(this.errorCorrectionLevel);
        outputDisplay.setMargin(this.margin);
        return outputDisplay;
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("font", this.font != null ? this.font.toJSON() : JSONObject.NULL);
        jSONObject.put("border", this.border != null ? this.border.toJSON() : JSONObject.NULL);
        jSONObject.put("verticalAlignment", this.verticalAlignment);
        jSONObject.put("horizontalAlignment", this.horizontalAlignment);
        jSONObject.put("showType", (Object)this.showType);
        jSONObject.put("encodingType", (Object)this.encodingType);
        jSONObject.put("errorCorrectionLevel", (Object)this.errorCorrectionLevel);
        jSONObject.put("margin", this.margin);
        return jSONObject;
    }

    public void fromJSON(JSONObject jSONObject) throws Throwable {
        this.font = U.R(new OutputFont(), jSONObject.optJSONObject("font"));
        this.border = U.R(new OutputBorder(), jSONObject.optJSONObject("border"));
        this.verticalAlignment = jSONObject.optInt("verticalAlignment");
        this.horizontalAlignment = jSONObject.optInt("horizontalAlignment");
        this.showType = jSONObject.optString("showType");
        this.encodingType = jSONObject.optString("encodingType");
        this.errorCorrectionLevel = jSONObject.optString("errorCorrectionLevel");
        this.margin = jSONObject.optInt("margin");
    }
}

