/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.pdfexport;

import com.bokesoft.yes.report.print.IUnitTrans;
import com.bokesoft.yes.report.print.paper.IPrintPaper;
import com.bokesoft.yes.report.print.pdfexport.IPDFUnitTrans;
import com.bokesoft.yes.report.print.pdfexport.PDFCellExport;
import com.bokesoft.yes.report.print.pdfexport.PDFEmbedExport;
import com.bokesoft.yes.report.print.pdfexport.PDFPageExport;
import com.bokesoft.yes.report.print.pdfexport.PDFSectionExport;
import com.bokesoft.yes.report.print.pdfexport.PDFTransContext;
import com.bokesoft.yes.report.print.transform.ICellExport;
import com.bokesoft.yes.report.print.transform.IEmbedExport;
import com.bokesoft.yes.report.print.transform.IPageExport;
import com.bokesoft.yes.report.print.transform.IReportExport;
import com.bokesoft.yes.report.print.transform.ISectionExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfReportConfiguration;
import net.sf.jasperreports.export.SimpleRtfReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;

public class PDFReportExport
implements IReportExport<PDFTransContext> {
    private IPDFUnitTrans unitTrans = null;
    private IPageExport<PDFTransContext> pageExport = null;
    private ISectionExport sectionExport = null;
    private ICellExport<PDFTransContext> cellExport = null;
    private IEmbedExport<PDFTransContext> embedExport = null;
    private JasperPrint jasperPrint = null;

    public PDFReportExport(IPDFUnitTrans iPDFUnitTrans) {
        this.unitTrans = iPDFUnitTrans;
        this.pageExport = new PDFPageExport(iPDFUnitTrans);
        this.sectionExport = new PDFSectionExport();
        this.cellExport = new PDFCellExport(iPDFUnitTrans);
        this.embedExport = new PDFEmbedExport();
    }

    @Override
    public IUnitTrans getUnitTrans() {
        return this.unitTrans;
    }

    @Override
    public void preparePaper(PDFTransContext pDFTransContext, int n, IPrintPaper iPrintPaper) {
        if (this.jasperPrint == null) {
            this.jasperPrint = new JasperPrint();
            this.jasperPrint.setName("JasperPrint");
            n = iPrintPaper.getWidth();
            int n2 = iPrintPaper.getHeight();
            if (iPrintPaper.getOrientation() == 0) {
                this.jasperPrint.setPageWidth(n);
                this.jasperPrint.setPageHeight(n2);
            } else {
                this.jasperPrint.setPageWidth(n2);
                this.jasperPrint.setPageHeight(n);
            }
            pDFTransContext.setJasperPrint(this.jasperPrint);
        }
        JRBasePrintPage jRBasePrintPage = new JRBasePrintPage();
        pDFTransContext.setPage(jRBasePrintPage);
        this.jasperPrint.addPage((JRPrintPage)jRBasePrintPage);
    }

    @Override
    public void export(ITransformContext iTransformContext) throws Throwable {
        this.export(iTransformContext, 0);
    }

    @Override
    public void export(ITransformContext object, int n) throws Throwable {
        object = ((PDFTransContext)object).getOutPutStream();
        switch (n) {
            case 0: {
                this.exportPdf((OutputStream)object);
                return;
            }
            case 2: {
                this.exportHtml((OutputStream)object);
                return;
            }
            case 1: {
                this.exportXlsx((OutputStream)object);
                return;
            }
            case 3: {
                this.exportRtf((OutputStream)object);
            }
        }
    }

    private void exportPdf(OutputStream outputStream) throws Throwable {
        JRPdfExporter jRPdfExporter = new JRPdfExporter();
        SimplePdfReportConfiguration simplePdfReportConfiguration = new SimplePdfReportConfiguration();
        jRPdfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
        simplePdfReportConfiguration.setForceLineBreakPolicy(Boolean.TRUE);
        simplePdfReportConfiguration.setForceSvgShapes(Boolean.FALSE);
        jRPdfExporter.setConfiguration((ReportExportConfiguration)simplePdfReportConfiguration);
        jRPdfExporter.exportReport();
    }

    private void exportXlsx(OutputStream outputStream) throws Throwable {
        JRXlsxExporter jRXlsxExporter = new JRXlsxExporter();
        jRXlsxExporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        jRXlsxExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
        outputStream = new SimpleXlsxReportConfiguration();
        jRXlsxExporter.setConfiguration((ReportExportConfiguration)outputStream);
        jRXlsxExporter.exportReport();
    }

    private void exportHtml(OutputStream outputStream) throws Throwable {
        HtmlExporter htmlExporter = new HtmlExporter();
        htmlExporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        htmlExporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(outputStream));
        outputStream = new SimpleHtmlReportConfiguration();
        htmlExporter.setConfiguration((ReportExportConfiguration)outputStream);
        htmlExporter.exportReport();
    }

    private void exportRtf(OutputStream outputStream) throws Throwable {
        JRRtfExporter jRRtfExporter = new JRRtfExporter();
        jRRtfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        jRRtfExporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(outputStream, "GBK"));
        outputStream = new SimpleRtfReportConfiguration();
        jRRtfExporter.setConfiguration((ReportExportConfiguration)outputStream);
        jRRtfExporter.exportReport();
    }

    @Override
    public IPageExport<PDFTransContext> getPageExport() {
        return this.pageExport;
    }

    @Override
    public ISectionExport getSectionExport() {
        return this.sectionExport;
    }

    @Override
    public ICellExport<PDFTransContext> getCellExport() {
        return this.cellExport;
    }

    @Override
    public IEmbedExport<PDFTransContext> getEmbedExport() {
        return this.embedExport;
    }
}

